/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.parsers.DelimitedParser;
import org.apache.druid.java.util.common.parsers.Parser;

public class DelimitedParseSpec
extends ParseSpec {
    private final String delimiter;
    private final String listDelimiter;
    private final List<String> columns;
    private final boolean hasHeaderRow;
    private final int skipHeaderRows;

    @JsonCreator
    public DelimitedParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="columns") List<String> columns, @JsonProperty(value="hasHeaderRow") boolean hasHeaderRow, @JsonProperty(value="skipHeaderRows") int skipHeaderRows) {
        super(timestampSpec, dimensionsSpec);
        this.delimiter = delimiter;
        this.listDelimiter = listDelimiter;
        this.columns = columns;
        this.hasHeaderRow = hasHeaderRow;
        this.skipHeaderRows = skipHeaderRows;
        if (columns != null) {
            for (String column : this.columns) {
                Preconditions.checkArgument((!column.contains(",") ? 1 : 0) != 0, (String)"Column[%s] has a comma, it cannot", (Object)column);
            }
        } else {
            Preconditions.checkArgument((boolean)hasHeaderRow, (Object)"If columns field is not set, the first row of your data must have your header and hasHeaderRow must be set to true.");
        }
    }

    @JsonProperty(value="delimiter")
    public String getDelimiter() {
        return this.delimiter;
    }

    @JsonProperty(value="listDelimiter")
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public boolean isHasHeaderRow() {
        return this.hasHeaderRow;
    }

    @JsonProperty(value="skipHeaderRows")
    public int getSkipHeaderRows() {
        return this.skipHeaderRows;
    }

    @Override
    public Parser<String, Object> makeParser() {
        return new DelimitedParser(this.delimiter, this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows, false);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new DelimitedParseSpec(spec, this.getDimensionsSpec(), this.delimiter, this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows);
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new DelimitedParseSpec(this.getTimestampSpec(), spec, this.delimiter, this.listDelimiter, this.columns, this.hasHeaderRow, this.skipHeaderRows);
    }
}

