/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.RegexReader;
import org.apache.druid.utils.CompressionUtils;

public class RegexInputFormat
implements InputFormat {
    public static final String TYPE_KEY = "regex";
    private final String pattern;
    private final String listDelimiter;
    private final List<String> columns;
    @JsonIgnore
    private final Supplier<Pattern> compiledPatternSupplier;

    @JsonCreator
    public RegexInputFormat(@JsonProperty(value="pattern") String pattern, @JsonProperty(value="listDelimiter") @Nullable String listDelimiter, @JsonProperty(value="columns") @Nullable List<String> columns) {
        this.pattern = pattern;
        this.listDelimiter = listDelimiter;
        this.columns = columns;
        this.compiledPatternSupplier = Suppliers.memoize(() -> Pattern.compile(pattern));
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getListDelimiter() {
        return this.listDelimiter;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public boolean isSplittable() {
        return false;
    }

    @Override
    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        return new RegexReader(inputRowSchema, source, this.pattern, (Pattern)this.compiledPatternSupplier.get(), this.listDelimiter, this.columns);
    }

    @Override
    public long getWeightedSize(String path, long size) {
        CompressionUtils.Format compressionFormat = CompressionUtils.Format.fromFileName(path);
        if (CompressionUtils.Format.GZ == compressionFormat) {
            return size * 4L;
        }
        return size;
    }
}

