/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.frame.key.RowKeyComparisonRunLengths;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.key.RunLengthEntry;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;

public class ByteRowKeyComparator
implements Comparator<byte[]> {
    private final List<KeyColumn> keyColumns;
    private final int firstFieldPosition;
    private final RowKeyComparisonRunLengths rowKeyComparisonRunLengths;
    private final ComplexMetricSerde[] complexMetricSerdes;
    private final ColumnType[] columnTypes;

    private ByteRowKeyComparator(List<KeyColumn> keyColumns, RowKeyComparisonRunLengths rowKeyComparisonRunLengths, ComplexMetricSerde[] complexMetricSerdes, ColumnType[] columnTypes) {
        this.keyColumns = keyColumns;
        this.firstFieldPosition = ByteRowKeyComparator.computeFirstFieldPosition(keyColumns.size());
        this.rowKeyComparisonRunLengths = rowKeyComparisonRunLengths;
        this.complexMetricSerdes = complexMetricSerdes;
        this.columnTypes = columnTypes;
    }

    public static ByteRowKeyComparator create(List<KeyColumn> keyColumns, RowSignature rowSignature) {
        RowKeyComparisonRunLengths rowKeyComparisonRunLengths = RowKeyComparisonRunLengths.create(keyColumns, rowSignature);
        RunLengthEntry[] runLengthEntries = rowKeyComparisonRunLengths.getRunLengthEntries();
        ComplexMetricSerde[] complexMetricSerdes = new ComplexMetricSerde[runLengthEntries.length];
        ColumnType[] columnTypes = new ColumnType[runLengthEntries.length];
        int fieldsSeenSoFar = 0;
        for (int i = 0; i < runLengthEntries.length; ++i) {
            if (runLengthEntries[i].isByteComparable()) {
                complexMetricSerdes[i] = null;
                columnTypes[i] = null;
            } else {
                String columnName = keyColumns.get(fieldsSeenSoFar).columnName();
                ColumnType columnType = rowSignature.getColumnType(columnName).orElse(null);
                if (columnType == null) {
                    throw DruidException.defensive("Column type required for column [%s] for comparison", columnName);
                }
                String complexTypeName = columnType.getComplexTypeName();
                if (complexTypeName == null) {
                    throw DruidException.defensive("Expected complex type name for column [%s] for comparison", columnName);
                }
                complexMetricSerdes[i] = (ComplexMetricSerde)Preconditions.checkNotNull((Object)ComplexMetrics.getSerdeForType(complexTypeName), (String)"Cannot find serde for column [%s] with type [%s]", (Object)columnName, (Object)complexTypeName);
                columnTypes[i] = columnType;
            }
            fieldsSeenSoFar += runLengthEntries[i].getRunLength();
        }
        return new ByteRowKeyComparator(keyColumns, RowKeyComparisonRunLengths.create(keyColumns, rowSignature), complexMetricSerdes, columnTypes);
    }

    public static int computeFirstFieldPosition(int fieldCount) {
        return Ints.checkedCast((long)((long)fieldCount * 4L));
    }

    @Override
    public int compare(byte[] keyArray1, byte[] keyArray2) {
        int currentRunStartPosition1 = this.firstFieldPosition;
        int currentRunStartPosition2 = this.firstFieldPosition;
        int fieldsComparedTillNow = 0;
        for (int i = 0; i < this.rowKeyComparisonRunLengths.getRunLengthEntries().length; ++i) {
            int cmp;
            RunLengthEntry runLengthEntry = this.rowKeyComparisonRunLengths.getRunLengthEntries()[i];
            if (runLengthEntry.getRunLength() <= 0) continue;
            int nextField = fieldsComparedTillNow + runLengthEntry.getRunLength();
            int currentRunEndPosition1 = RowKeyReader.fieldEndPosition(keyArray1, nextField - 1);
            int currentRunEndPosition2 = RowKeyReader.fieldEndPosition(keyArray2, nextField - 1);
            if (!runLengthEntry.isByteComparable()) {
                assert (runLengthEntry.getRunLength() == 1);
                cmp = FrameReaderUtils.compareComplexTypes(keyArray1, currentRunStartPosition1, keyArray2, currentRunStartPosition2, this.columnTypes[i], this.complexMetricSerdes[i]);
            } else {
                cmp = FrameReaderUtils.compareByteArraysUnsigned(keyArray1, currentRunStartPosition1, currentRunEndPosition1 - currentRunStartPosition1, keyArray2, currentRunStartPosition2, currentRunEndPosition2 - currentRunStartPosition2);
            }
            if (cmp != 0) {
                return runLengthEntry.getOrder() == KeyOrder.ASCENDING ? cmp : -cmp;
            }
            fieldsComparedTillNow = nextField;
            currentRunStartPosition1 = currentRunEndPosition1;
            currentRunStartPosition2 = currentRunEndPosition2;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteRowKeyComparator that = (ByteRowKeyComparator)o;
        return this.firstFieldPosition == that.firstFieldPosition && Objects.equals(this.keyColumns, that.keyColumns) && Objects.equals(this.rowKeyComparisonRunLengths, that.rowKeyComparisonRunLengths) && Arrays.equals(this.complexMetricSerdes, that.complexMetricSerdes) && Arrays.equals(this.columnTypes, that.columnTypes);
    }

    public int hashCode() {
        int result = Objects.hash(this.keyColumns, this.firstFieldPosition, this.rowKeyComparisonRunLengths);
        result = 31 * result + Arrays.hashCode(this.complexMetricSerdes);
        result = 31 * result + Arrays.hashCode(this.columnTypes);
        return result;
    }

    public String toString() {
        return "ByteRowKeyComparator{keyColumns=" + String.valueOf(this.keyColumns) + ", firstFieldPosition=" + this.firstFieldPosition + ", rowKeyComparisonRunLengths=" + String.valueOf(this.rowKeyComparisonRunLengths) + ", complexMetricSerdes=" + Arrays.toString(this.complexMetricSerdes) + ", columnTypes=" + Arrays.toString(this.columnTypes) + "}";
    }
}

