/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.manager;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.java.util.common.ISE;

public class AccumulatingProcessorManager<T, R>
implements ProcessorManager<T, R> {
    private final ProcessorManager<T, ?> delegate;
    private final BiFunction<R, T, R> accumulateFn;
    private R currentResult;

    public AccumulatingProcessorManager(ProcessorManager<T, ?> delegate, R initialResult, BiFunction<R, T, R> accumulateFn) {
        this.delegate = delegate;
        this.currentResult = Preconditions.checkNotNull(initialResult, (Object)"initialResult");
        this.accumulateFn = accumulateFn;
    }

    @Override
    public ListenableFuture<Optional<ProcessorAndCallback<T>>> next() {
        if (this.currentResult == null) {
            throw new ISE("Closed", new Object[0]);
        }
        return FutureUtils.transform(this.delegate.next(), nextProcessor -> nextProcessor.map(retVal -> new ProcessorAndCallback<Object>(retVal.processor(), r -> {
            this.currentResult = this.accumulateFn.apply(this.currentResult, r);
            retVal.onComplete(r);
        })));
    }

    @Override
    public R result() {
        return (R)Preconditions.checkNotNull(this.currentResult, (Object)"currentResult");
    }

    @Override
    public void close() {
        this.currentResult = null;
        this.delegate.close();
    }
}

