/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.nio.ByteBuffer;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.read.columnar.ColumnPlus;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.read.columnar.FrameColumnReaderUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;
import org.apache.druid.query.rowsandcols.column.accessor.ObjectColumnAccessorBase;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class StringArrayFrameColumnReader
implements FrameColumnReader {
    private final int columnNumber;

    StringArrayFrameColumnReader(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public Column readRACColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory);
        long positionOfLengths = StringArrayFrameColumnReader.getStartOfStringLengthSection(frame.numRows());
        long positionOfPayloads = this.getStartOfStringDataSection(memory, frame.numRows());
        StringArrayFrameColumn frameCol = new StringArrayFrameColumn(frame, memory, positionOfLengths, positionOfPayloads);
        return new ColumnAccessorBasedColumn(frameCol);
    }

    @Override
    public ColumnPlus readColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory);
        long startOfStringLengthSection = StringArrayFrameColumnReader.getStartOfStringLengthSection(frame.numRows());
        long startOfStringDataSection = this.getStartOfStringDataSection(memory, frame.numRows());
        StringArrayFrameColumn baseColumn = new StringArrayFrameColumn(frame, memory, startOfStringLengthSection, startOfStringDataSection);
        return new ColumnPlus(baseColumn, new ColumnCapabilitiesImpl().setType(ColumnType.STRING_ARRAY).setHasMultipleValues(false).setDictionaryEncoded(false), frame.numRows());
    }

    private void validate(Memory region) {
        if (region.getCapacity() < 2L) {
            throw DruidException.defensive("Column[%s] is not big enough for a header", this.columnNumber);
        }
        byte typeCode = region.getByte(0L);
        if (typeCode != 6) {
            throw DruidException.defensive("Column[%s] does not have the correct type code; expected[%s], got[%s]", this.columnNumber, (byte)6, typeCode);
        }
    }

    private static long getStartOfCumulativeLengthSection() {
        return 2L;
    }

    private static long getStartOfStringLengthSection(int numRows) {
        return 2L + 4L * (long)numRows;
    }

    private long getStartOfStringDataSection(Memory memory, int numRows) {
        if (numRows < 0) {
            throw DruidException.defensive("Encountered -ve numRows [%s] while reading frame", numRows);
        }
        int totalNumValues = FrameColumnReaderUtils.getAdjustedCumulativeRowLength(memory, StringArrayFrameColumnReader.getStartOfCumulativeLengthSection(), numRows - 1);
        return StringArrayFrameColumnReader.getStartOfStringLengthSection(numRows) + 4L * (long)totalNumValues;
    }

    private static class StringArrayFrameColumn
    extends ObjectColumnAccessorBase
    implements BaseColumn {
        private final Frame frame;
        private final Memory memory;
        private final long startOfStringLengthSection;
        private final long startOfStringDataSection;

        private StringArrayFrameColumn(Frame frame, Memory memory, long startOfStringLengthSection, long startOfStringDataSection) {
            this.frame = frame;
            this.memory = memory;
            this.startOfStringLengthSection = startOfStringLengthSection;
            this.startOfStringDataSection = startOfStringDataSection;
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
            return new ObjectColumnSelector<Object>(){

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }

                @Override
                @Nullable
                public Object getObject() {
                    return this.getRowAsObject(frame.physicalRow(offset.getOffset()), true);
                }

                @Override
                public Class<?> classOfObject() {
                    return Object[].class;
                }
            };
        }

        @Override
        public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
            class StringArrayFrameVectorObjectSelector
            implements VectorObjectSelector {
                private final Object[] vector;
                private int id;

                StringArrayFrameVectorObjectSelector() {
                    this.vector = new Object[offset.getMaxVectorSize()];
                    this.id = -1;
                }

                @Override
                public Object[] getObjectVector() {
                    this.computeVectorIfNeeded();
                    return this.vector;
                }

                @Override
                public int getMaxVectorSize() {
                    return offset.getMaxVectorSize();
                }

                @Override
                public int getCurrentVectorSize() {
                    return offset.getCurrentVectorSize();
                }

                private void computeVectorIfNeeded() {
                    if (this.id == offset.getId()) {
                        return;
                    }
                    if (offset.isContiguous()) {
                        int start = offset.getStartOffset();
                        for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = StringArrayFrameColumn.this.frame.physicalRow(i + start);
                            this.vector[i] = StringArrayFrameColumn.this.getRowAsObject(physicalRow, true);
                        }
                    } else {
                        int[] offsets = offset.getOffsets();
                        for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                            int physicalRow = StringArrayFrameColumn.this.frame.physicalRow(offsets[i]);
                            this.vector[i] = StringArrayFrameColumn.this.getRowAsObject(physicalRow, true);
                        }
                    }
                    this.id = offset.getId();
                }
            }
            return new StringArrayFrameVectorObjectSelector();
        }

        @Override
        public void close() {
        }

        @Override
        public ColumnType getType() {
            return ColumnType.STRING_ARRAY;
        }

        @Override
        public int numRows() {
            return this.frame.numRows();
        }

        @Override
        protected Object getVal(int rowNum) {
            return this.getRowAsObject(this.frame.physicalRow(rowNum), true);
        }

        @Override
        protected Comparator<Object> getComparator() {
            return Comparator.nullsFirst(ColumnType.STRING_ARRAY.getStrategy());
        }

        @Nullable
        private ByteBuffer getStringUtf8(int index) {
            long dataStart;
            if (this.startOfStringLengthSection > Long.MAX_VALUE - 4L * (long)index) {
                throw DruidException.defensive("length index would overflow trying to read the frame memory!", new Object[0]);
            }
            int dataEndVariableIndex = this.memory.getInt(this.startOfStringLengthSection + 4L * (long)index);
            if (this.startOfStringDataSection > Long.MAX_VALUE - (long)dataEndVariableIndex) {
                throw DruidException.defensive("data end index would overflow trying to read the frame memory!", new Object[0]);
            }
            long dataEnd = this.startOfStringDataSection + (long)dataEndVariableIndex;
            if (index == 0) {
                dataStart = this.startOfStringDataSection;
            } else {
                int dataStartVariableIndex = this.memory.getInt(this.startOfStringLengthSection + 4L * (long)(index - 1));
                if (this.startOfStringDataSection > Long.MAX_VALUE - (long)dataStartVariableIndex) {
                    throw DruidException.defensive("data start index would overflow trying to read the frame memory!", new Object[0]);
                }
                dataStart = this.startOfStringDataSection + (long)dataStartVariableIndex;
            }
            int dataLength = Ints.checkedCast((long)(dataEnd - dataStart));
            if (dataLength == 1 && this.memory.getByte(dataStart) == -1) {
                return null;
            }
            return FrameReaderUtils.readByteBuffer(this.memory, dataStart, dataLength);
        }

        @Nullable
        private String getString(int index) {
            ByteBuffer stringUtf8 = this.getStringUtf8(index);
            if (stringUtf8 == null) {
                return null;
            }
            return StringUtils.fromUtf8(stringUtf8);
        }

        @Nullable
        private Object getRowAsObject(int physicalRow, boolean decode) {
            int cumulativeRowLength = FrameColumnReaderUtils.getCumulativeRowLength(this.memory, StringArrayFrameColumnReader.getStartOfCumulativeLengthSection(), physicalRow);
            if (FrameColumnReaderUtils.isNullRow(cumulativeRowLength)) {
                return null;
            }
            int rowLength = physicalRow == 0 ? cumulativeRowLength : cumulativeRowLength - FrameColumnReaderUtils.getAdjustedCumulativeRowLength(this.memory, StringArrayFrameColumnReader.getStartOfCumulativeLengthSection(), physicalRow - 1);
            if (rowLength == 0) {
                return ObjectArrays.EMPTY_ARRAY;
            }
            Object[] row = new Object[rowLength];
            for (int i = 0; i < rowLength; ++i) {
                int index = cumulativeRowLength - rowLength + i;
                row[i] = decode ? this.getString(index) : this.getStringUtf8(index);
            }
            return row;
        }
    }
}

