/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment.row;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.segment.FrameFilteredOffset;
import org.apache.druid.frame.segment.row.CursorFrameRowPointer;
import org.apache.druid.frame.segment.row.FrameColumnSelectorFactory;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;

public class RowFrameCursorFactory
implements CursorFactory {
    private final Frame frame;
    private final FrameReader frameReader;
    private final List<FieldReader> fieldReaders;

    public RowFrameCursorFactory(Frame frame, FrameReader frameReader, List<FieldReader> fieldReaders) {
        this.frame = frame.ensureRowBased();
        this.frameReader = frameReader;
        this.fieldReaders = fieldReaders;
    }

    @Override
    public CursorHolder makeCursorHolder(final CursorBuildSpec spec) {
        final List ordering = Collections.emptyList();
        return new CursorHolder(){

            @Override
            @Nullable
            public Cursor asCursor() {
                Filter filterToUse = FrameCursorUtils.buildFilter(spec.getFilter(), spec.getInterval());
                SimpleAscendingOffset baseOffset = new SimpleAscendingOffset(RowFrameCursorFactory.this.frame.numRows());
                ColumnSelectorFactory columnSelectorFactory = spec.getVirtualColumns().wrap(new FrameColumnSelectorFactory(RowFrameCursorFactory.this.frame, RowFrameCursorFactory.this.frameReader.signature(), RowFrameCursorFactory.this.fieldReaders, new CursorFrameRowPointer(RowFrameCursorFactory.this.frame, baseOffset)));
                SimpleSettableOffset offset = filterToUse == null ? baseOffset : new FrameFilteredOffset(baseOffset, columnSelectorFactory, filterToUse);
                FrameCursor cursor = new FrameCursor(offset, columnSelectorFactory);
                return cursor;
            }

            @Override
            @Nullable
            public List<OrderBy> getOrdering() {
                return ordering;
            }
        };
    }

    @Override
    public RowSignature getRowSignature() {
        return this.frameReader.signature();
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.frameReader.signature().getColumnCapabilities(column);
    }
}

