/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameSort;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.InvalidFieldException;
import org.apache.druid.frame.write.InvalidNullByteException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class RowBasedFrameWriter
implements FrameWriter {
    public static final int ROW_OFFSET_REGION = 0;
    public static final int ROW_DATA_REGION = 1;
    public static final int NUM_REGIONS = 2;
    static final int BASE_DATA_ALLOCATION_SIZE = 8192;
    private final FrameType frameType;
    private final RowSignature signature;
    private final List<KeyColumn> sortColumns;
    private final List<FieldWriter> fieldWriters;
    private final Supplier<MemoryRange<Memory>> rowMemorySupplier;
    @Nullable
    private final AppendableMemory rowOrderMemory;
    private final AppendableMemory rowOffsetMemory;
    private final AppendableMemory dataMemory;
    private int numRows = 0;
    private boolean written = false;

    public RowBasedFrameWriter(FrameType frameType, RowSignature signature, List<KeyColumn> sortColumns, List<FieldWriter> fieldWriters, @Nullable Supplier<MemoryRange<Memory>> rowMemorySupplier, @Nullable AppendableMemory rowOrderMemory, AppendableMemory rowOffsetMemory, AppendableMemory dataMemory) {
        this.frameType = frameType;
        this.signature = signature;
        this.sortColumns = sortColumns;
        this.rowMemorySupplier = rowMemorySupplier;
        this.fieldWriters = fieldWriters;
        this.rowOrderMemory = rowOrderMemory;
        this.rowOffsetMemory = rowOffsetMemory;
        this.dataMemory = dataMemory;
        FrameWriterUtils.verifySortColumns(sortColumns, signature);
        Set<String> disallowedFieldNames = FrameWriterUtils.findDisallowedFieldNames(signature);
        if (!disallowedFieldNames.isEmpty()) {
            throw new IAE("Disallowed field names: %s", disallowedFieldNames);
        }
    }

    @Override
    public boolean addSelection() {
        if (this.written) {
            throw new ISE("Cannot modify after writing", new Object[0]);
        }
        if (this.numRows == Integer.MAX_VALUE) {
            return false;
        }
        if (this.rowOrderMemory != null && !this.rowOrderMemory.reserveAdditional(4)) {
            return false;
        }
        if (!this.rowOffsetMemory.reserveAdditional(8)) {
            return false;
        }
        if (!this.writeData()) {
            return false;
        }
        MemoryRange<WritableMemory> rowOffsetCursor = this.rowOffsetMemory.cursor();
        rowOffsetCursor.memory().putLong(rowOffsetCursor.start(), this.dataMemory.size());
        this.rowOffsetMemory.advanceCursor(8);
        if (this.rowOrderMemory != null) {
            MemoryRange<WritableMemory> rowOrderCursor = this.rowOrderMemory.cursor();
            rowOrderCursor.memory().putInt(rowOrderCursor.start(), this.numRows);
            this.rowOrderMemory.advanceCursor(4);
        }
        ++this.numRows;
        return true;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public long getTotalSize() {
        return 18L + this.computeRowOrderSize() + 16L + this.rowOffsetMemory.size() + this.dataMemory.size();
    }

    @Override
    public long writeTo(WritableMemory memory, long startPosition) {
        if (this.written) {
            throw new ISE("Cannot write twice", new Object[0]);
        }
        long totalSize = this.getTotalSize();
        long currentPosition = startPosition;
        currentPosition += FrameWriterUtils.writeFrameHeader(memory, startPosition, this.frameType, totalSize, this.numRows, 2, this.mustSort());
        if (this.mustSort()) {
            currentPosition += this.rowOrderMemory.writeTo(memory, currentPosition);
        }
        long regionsStart = 18L + this.computeRowOrderSize() + 16L;
        memory.putLong(currentPosition, regionsStart + this.rowOffsetMemory.size());
        memory.putLong(currentPosition + 8L, regionsStart + this.rowOffsetMemory.size() + this.dataMemory.size());
        currentPosition += 16L;
        currentPosition += this.rowOffsetMemory.writeTo(memory, currentPosition);
        currentPosition += this.dataMemory.writeTo(memory, currentPosition);
        if (currentPosition != totalSize) {
            throw new ISE("Expected to write [%,d] bytes, but wrote [%,d] bytes.", totalSize, currentPosition);
        }
        if (this.mustSort()) {
            FrameSort.sort(Frame.wrap((Memory)memory), FrameReader.create(this.signature), this.sortColumns);
        }
        this.written = true;
        return totalSize;
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions(() -> {
            Closer closer = Closer.create();
            closer.register(this.rowOrderMemory);
            closer.register(this.rowOffsetMemory);
            closer.register(this.dataMemory);
            if (this.fieldWriters != null) {
                closer.registerAll(this.fieldWriters);
            }
            closer.close();
        });
    }

    private long computeRowOrderSize() {
        return this.mustSort() ? this.rowOrderMemory.size() : 0L;
    }

    private boolean mustSort() {
        return this.rowOrderMemory != null;
    }

    private boolean writeData() {
        MemoryRange<Memory> rowMemory;
        if (this.rowMemorySupplier != null && (rowMemory = this.rowMemorySupplier.get()) != null) {
            return this.writeDataUsingRowMemory(rowMemory);
        }
        return this.writeDataUsingFieldWriters();
    }

    private boolean writeDataUsingRowMemory(MemoryRange<Memory> rowMemory) {
        if (!this.dataMemory.reserveAdditional(Ints.checkedCast((long)rowMemory.length()))) {
            return false;
        }
        MemoryRange<WritableMemory> cursor = this.dataMemory.cursor();
        rowMemory.memory().copyTo(rowMemory.start(), cursor.memory(), cursor.start(), rowMemory.length());
        this.dataMemory.advanceCursor(Ints.checkedCast((long)rowMemory.length()));
        return true;
    }

    private boolean writeDataUsingFieldWriters() {
        assert (this.fieldWriters != null);
        long fieldPositionBytes = (long)this.fieldWriters.size() * 4L;
        if (this.numRows == 0 && !this.dataMemory.reserveAdditional(Ints.checkedCast((long)Math.max(fieldPositionBytes, 8192L)))) {
            return false;
        }
        MemoryRange<WritableMemory> dataCursor = this.dataMemory.cursor();
        long remainingInBlock = dataCursor.length();
        long bytesWritten = fieldPositionBytes;
        int reserveMultiple = 1;
        for (int i = 0; i < this.fieldWriters.size(); ++i) {
            long writeResult;
            FieldWriter fieldWriter = this.fieldWriters.get(i);
            try {
                writeResult = fieldWriter.writeTo(dataCursor.memory(), dataCursor.start() + bytesWritten, remainingInBlock - bytesWritten);
            }
            catch (InvalidNullByteException inbe) {
                throw InvalidNullByteException.builder(inbe).column(this.signature.getColumnName(i)).build();
            }
            catch (ParseException pe) {
                throw Throwables.propagate((Throwable)pe);
            }
            catch (Exception e) {
                throw InvalidFieldException.builder().column(this.signature.getColumnName(i)).errorMsg(e.getMessage()).build();
            }
            if (writeResult < 0L) {
                i = -1;
                int priorAllocation = 8192 * reserveMultiple;
                int nextAllocation = Math.min(this.dataMemory.availableToReserve(), Ints.checkedCast((long)(8192L * (long)(reserveMultiple *= 2))));
                if (nextAllocation > priorAllocation) {
                    if (!this.dataMemory.reserveAdditional(nextAllocation)) {
                        throw DruidException.defensive("Unexpected failure of dataMemory.reserveAdditional", new Object[0]);
                    }
                } else {
                    return false;
                }
                dataCursor = this.dataMemory.cursor();
                remainingInBlock = dataCursor.length();
                bytesWritten = fieldPositionBytes;
                continue;
            }
            dataCursor.memory().putInt(dataCursor.start() + (long)i * 4L, Ints.checkedCast((long)(bytesWritten += writeResult)));
        }
        this.dataMemory.advanceCursor(Ints.checkedCast((long)bytesWritten));
        return true;
    }
}

