/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Predicate;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;

public class FilteringYieldingAccumulator<OutType, T>
extends YieldingAccumulator<OutType, T> {
    private final Predicate<? super T> pred;
    private final YieldingAccumulator<OutType, T> accumulator;
    private volatile boolean didSomething = false;

    public FilteringYieldingAccumulator(Predicate<? super T> pred, YieldingAccumulator<OutType, T> accumulator) {
        this.pred = pred;
        this.accumulator = accumulator;
    }

    @Override
    public void yield() {
        this.accumulator.yield();
    }

    @Override
    public boolean yielded() {
        return this.accumulator.yielded();
    }

    @Override
    public void reset() {
        this.didSomething = false;
        this.accumulator.reset();
    }

    public boolean didSomething() {
        return this.didSomething;
    }

    @Override
    public OutType accumulate(OutType accumulated, T in) {
        if (this.pred.apply(in)) {
            if (!this.didSomething) {
                this.didSomething = true;
            }
            return this.accumulator.accumulate(accumulated, in);
        }
        return accumulated;
    }
}

