/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Accumulators;
import org.apache.druid.java.util.common.guava.ConcatSequence;
import org.apache.druid.java.util.common.guava.LimitedSequence;
import org.apache.druid.java.util.common.guava.MappedSequence;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.SkippingSequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;

public interface Sequence<T> {
    public <OutType> OutType accumulate(OutType var1, Accumulator<OutType, T> var2);

    public <OutType> Yielder<OutType> toYielder(OutType var1, YieldingAccumulator<OutType, T> var2);

    default public <U> Sequence<U> map(Function<? super T, ? extends U> mapper) {
        return new MappedSequence<T, U>(this, mapper);
    }

    default public Sequence<T> filter(Predicate<? super T> predicate) {
        return Sequences.filter(this, predicate);
    }

    default public List<T> toList() {
        return this.accumulate(new ArrayList(), Accumulators.list());
    }

    default public Sequence<T> skip(long skip) {
        Preconditions.checkArgument((skip >= 0L ? 1 : 0) != 0, (Object)"skip >= 0");
        if (skip >= 1L) {
            return new SkippingSequence(this, skip);
        }
        return this;
    }

    default public Sequence<T> limit(long limit) {
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit >= 0");
        return new LimitedSequence(this, limit);
    }

    default public <R> Sequence<R> flatMap(Function<? super T, ? extends Sequence<? extends R>> mapper) {
        return new ConcatSequence(this.map(mapper));
    }

    default public <R> Sequence<R> flatMerge(Function<? super T, ? extends Sequence<? extends R>> mapper, Ordering<? super R> ordering) {
        return new MergeSequence<R>(ordering, this.map(mapper));
    }

    default public void forEach(Consumer<? super T> action) {
        this.accumulate(null, (accumulated, in) -> {
            action.accept(in);
            return null;
        });
    }

    default public Sequence<T> withEffect(Runnable effect, Executor effectExecutor) {
        return Sequences.withEffect(this, effect, effectExecutor);
    }

    default public Sequence<T> withBaggage(Closeable baggage) {
        return Sequences.withBaggage(this, baggage);
    }
}

