/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.NettyHttpClient;
import org.apache.druid.java.util.http.client.netty.HttpClientPipelineFactory;
import org.apache.druid.java.util.http.client.pool.ChannelResourceFactory;
import org.apache.druid.java.util.http.client.pool.ResourcePool;
import org.apache.druid.java.util.http.client.pool.ResourcePoolConfig;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;

public class HttpClientInit {
    public static HttpClient createClient(HttpClientConfig config, Lifecycle lifecycle) {
        try {
            final HashedWheelTimer timer = new HashedWheelTimer(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HttpClient-Timer-%s").build(), ThreadNameDeterminer.CURRENT, 100L, TimeUnit.MILLISECONDS, 512);
            lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                @Override
                public void start() {
                    timer.start();
                }

                @Override
                public void stop() {
                    timer.stop();
                }
            });
            return lifecycle.addMaybeStartManagedInstance(new NettyHttpClient(new ResourcePool<String, ChannelFuture>(new ChannelResourceFactory(HttpClientInit.createBootstrap(lifecycle, (Timer)timer, config.getBossPoolSize(), config.getWorkerPoolSize()), config.getSslContext(), config.getProxyConfig(), (Timer)timer, config.getSslHandshakeTimeout() == null ? -1L : config.getSslHandshakeTimeout().getMillis()), new ResourcePoolConfig(config.getNumConnections(), config.getUnusedConnectionTimeoutDuration().getMillis()), config.isEagerInitialization()), config.getReadTimeout(), config.getCompressionCodec(), (Timer)timer));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext sslContextWithTrustedKeyStore(String keyStorePath, String keyStorePassword) {
        SSLContext sSLContext;
        FileInputStream in = new FileInputStream(keyStorePath);
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(in, keyStorePassword.toCharArray());
            in.close();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            sSLContext = sslContext;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        in.close();
        return sSLContext;
    }

    private static ClientBootstrap createBootstrap(Lifecycle lifecycle, Timer timer, int bossPoolSize, int workerPoolSize) {
        NioClientBossPool bossPool = new NioClientBossPool((Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HttpClient-Netty-Boss-%s").build()), bossPoolSize, timer, ThreadNameDeterminer.CURRENT);
        NioWorkerPool workerPool = new NioWorkerPool((Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HttpClient-Netty-Worker-%s").build()), workerPoolSize, ThreadNameDeterminer.CURRENT);
        final ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool));
        bootstrap.setOption("keepAlive", (Object)true);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpClientPipelineFactory());
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        try {
            lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                @Override
                public void start() {
                }

                @Override
                public void stop() {
                    bootstrap.releaseExternalResources();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bootstrap;
    }
}

