/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.KeyedDiff;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcCgroupV2Discoverer;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupV2CpuMonitor
extends FeedDefiningMonitor {
    private static final Logger LOG = new Logger(CgroupV2CpuMonitor.class);
    private static final String CPU_STAT_FILE = "cpu.stat";
    private static final String SNAPSHOT = "snapshot";
    final CgroupDiscoverer cgroupDiscoverer;
    final Map<String, String[]> dimensions;
    private final KeyedDiff diff = new KeyedDiff();

    public CgroupV2CpuMonitor(CgroupDiscoverer cgroupDiscoverer, Map<String, String[]> dimensions, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.dimensions = dimensions;
    }

    @VisibleForTesting
    CgroupV2CpuMonitor(CgroupDiscoverer cgroupDiscoverer) {
        this(cgroupDiscoverer, (Map<String, String[]>)ImmutableMap.of(), "metrics");
    }

    CgroupV2CpuMonitor() {
        this(new ProcSelfCgroupDiscoverer(ProcCgroupV2Discoverer.class));
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder = this.builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        Snapshot snapshot = this.snapshot();
        Map<String, Long> elapsed = this.diff.to("usage", (Map<String, Long>)ImmutableMap.builder().put((Object)"user", (Object)snapshot.getUserUsec()).put((Object)"system", (Object)snapshot.getSystemUsec()).put((Object)"total", (Object)snapshot.getUsageUsec()).put((Object)SNAPSHOT, (Object)ChronoUnit.MICROS.between(Instant.EPOCH, Instant.now())).build());
        if (elapsed != null) {
            long elapsedUsecs = elapsed.get(SNAPSHOT);
            double totalUsagePct = 100.0 * (double)elapsed.get("total").longValue() / (double)elapsedUsecs;
            double sysUsagePct = 100.0 * (double)elapsed.get("system").longValue() / (double)elapsedUsecs;
            double userUsagePct = 100.0 * (double)elapsed.get("user").longValue() / (double)elapsedUsecs;
            emitter.emit(builder.setMetric("cgroup/cpu/usage/total/percentage", totalUsagePct));
            emitter.emit(builder.setMetric("cgroup/cpu/usage/sys/percentage", sysUsagePct));
            emitter.emit(builder.setMetric("cgroup/cpu/usage/user/percentage", userUsagePct));
        }
        return true;
    }

    public Snapshot snapshot() {
        HashMap<String, Long> entries = new HashMap<String, Long>();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(this.cgroupDiscoverer.discover("cpu").toString(), CPU_STAT_FILE));){
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(Pattern.quote(" "));
                if (parts.length == 2) {
                    entries.put(parts[0], Longs.tryParse((String)parts[1]));
                }
                line = reader.readLine();
            }
        }
        catch (IOException | RuntimeException ex) {
            LOG.error(ex, "Unable to fetch cpu snapshot", new Object[0]);
        }
        return new Snapshot((Long)entries.get("usage_usec"), (Long)entries.get("user_usec"), (Long)entries.get("system_usec"));
    }

    public static class Snapshot {
        private final long usageUsec;
        private final long userUsec;
        private final long systemUsec;

        public Snapshot(long usageUsec, long userUsec, long systemUsec) {
            this.usageUsec = usageUsec;
            this.userUsec = userUsec;
            this.systemUsec = systemUsec;
        }

        public long getUsageUsec() {
            return this.usageUsec;
        }

        public long getUserUsec() {
            return this.userUsec;
        }

        public long getSystemUsec() {
            return this.systemUsec;
        }
    }
}

