/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StreamUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.SysMonitor;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarLoader;

public class SigarUtil {
    private static final Logger log = new Logger(SigarUtil.class);

    public static Sigar getSigar() {
        return new Sigar();
    }

    public static long getCurrentProcessId() {
        return CurrentProcessIdHolder.CURRENT_PROCESS_ID;
    }

    static {
        SigarLoader loader = new SigarLoader(Sigar.class);
        try {
            String libName = loader.getLibraryName();
            URL url = SysMonitor.class.getResource("/" + libName);
            if (url != null) {
                File tmpDir = FileUtils.createTempDir("sigar");
                tmpDir.deleteOnExit();
                File nativeLibTmpFile = new File(tmpDir, libName);
                nativeLibTmpFile.deleteOnExit();
                StreamUtils.copyToFileAndClose(url.openStream(), nativeLibTmpFile);
                log.info("Loading sigar native lib at tmpPath[%s]", nativeLibTmpFile);
                loader.load(nativeLibTmpFile.getParent());
            } else {
                log.info("No native libs found in jar, letting the normal load mechanisms figger it out.", new Object[0]);
            }
        }
        catch (IOException | ArchLoaderException | ArchNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CurrentProcessIdHolder {
        private static final long CURRENT_PROCESS_ID = new Sigar().getPid();

        private CurrentProcessIdHolder() {
        }
    }
}

