/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;

public class ExpressionProcessingConfig {
    private static final Logger LOG = new Logger(ExpressionProcessingConfig.class);
    public static final String NULL_HANDLING_LEGACY_LOGICAL_OPS_STRING = "druid.expressions.useStrictBooleans";
    public static final String PROCESS_ARRAYS_AS_MULTIVALUE_STRINGS_CONFIG_STRING = "druid.expressions.processArraysAsMultiValueStrings";
    public static final String HOMOGENIZE_NULL_MULTIVALUE_STRING_ARRAYS = "druid.expressions.homogenizeNullMultiValueStringArrays";
    public static final String ALLOW_VECTORIZE_FALLBACK = "druid.expressions.allowVectorizeFallback";
    @JsonProperty(value="processArraysAsMultiValueStrings")
    private final boolean processArraysAsMultiValueStrings;
    @JsonProperty(value="homogenizeNullMultiValueStringArrays")
    private final boolean homogenizeNullMultiValueStringArrays;
    @JsonProperty(value="allowVectorizeFallback")
    private final boolean allowVectorizeFallback;
    @Deprecated
    @JsonProperty(value="useStrictBooleans")
    private final boolean useStrictBooleans;

    @JsonCreator
    public ExpressionProcessingConfig(@Deprecated @JsonProperty(value="useStrictBooleans") @Nullable Boolean useStrictBooleans, @JsonProperty(value="processArraysAsMultiValueStrings") @Nullable Boolean processArraysAsMultiValueStrings, @JsonProperty(value="homogenizeNullMultiValueStringArrays") @Nullable Boolean homogenizeNullMultiValueStringArrays, @JsonProperty(value="allowVectorizeFallback") @Nullable Boolean allowVectorizeFallback) {
        this.useStrictBooleans = ExpressionProcessingConfig.getWithPropertyFallback(useStrictBooleans, NULL_HANDLING_LEGACY_LOGICAL_OPS_STRING, "true");
        this.processArraysAsMultiValueStrings = ExpressionProcessingConfig.getWithPropertyFallbackFalse(processArraysAsMultiValueStrings, PROCESS_ARRAYS_AS_MULTIVALUE_STRINGS_CONFIG_STRING);
        this.homogenizeNullMultiValueStringArrays = ExpressionProcessingConfig.getWithPropertyFallbackFalse(homogenizeNullMultiValueStringArrays, HOMOGENIZE_NULL_MULTIVALUE_STRING_ARRAYS);
        this.allowVectorizeFallback = ExpressionProcessingConfig.getWithPropertyFallbackFalse(allowVectorizeFallback, ALLOW_VECTORIZE_FALLBACK);
    }

    public boolean processArraysAsMultiValueStrings() {
        return this.processArraysAsMultiValueStrings;
    }

    public boolean isHomogenizeNullMultiValueStringArrays() {
        return this.homogenizeNullMultiValueStringArrays;
    }

    public boolean allowVectorizeFallback() {
        return this.allowVectorizeFallback;
    }

    private static boolean getWithPropertyFallbackFalse(@Nullable Boolean value, String property) {
        return ExpressionProcessingConfig.getWithPropertyFallback(value, property, "false");
    }

    private static boolean getWithPropertyFallback(@Nullable Boolean value, String property, String fallback) {
        return value != null ? value : Boolean.valueOf(System.getProperty(property, fallback));
    }
}

