/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class LongUnivariateFunctionVectorProcessor<TInput>
implements ExprVectorProcessor<long[]> {
    final ExprVectorProcessor<TInput> processor;
    final boolean[] outNulls;
    final long[] outValues;

    public LongUnivariateFunctionVectorProcessor(ExprVectorProcessor<TInput> processor) {
        this.processor = processor;
        this.outNulls = new boolean[processor.maxVectorSize()];
        this.outValues = new long[processor.maxVectorSize()];
    }

    @Override
    public final ExprEvalVector<long[]> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector<TInput> lhs = this.processor.evalVector(bindings);
        int currentSize = bindings.getCurrentVectorSize();
        boolean[] inputNulls = lhs.getNullVector();
        boolean hasNulls = inputNulls != null;
        TInput input = lhs.values();
        if (hasNulls) {
            for (int i = 0; i < currentSize; ++i) {
                this.outNulls[i] = inputNulls[i];
                if (!this.outNulls[i]) {
                    this.processIndex(input, i);
                    continue;
                }
                this.outValues[i] = 0L;
            }
        } else {
            for (int i = 0; i < currentSize; ++i) {
                this.outNulls[i] = false;
                this.processIndex(input, i);
            }
        }
        return this.asEval();
    }

    @Override
    public int maxVectorSize() {
        return this.processor.maxVectorSize();
    }

    abstract void processIndex(TInput var1, int var2);

    final ExprEvalVector<long[]> asEval() {
        return new ExprEvalLongVector(this.outValues, this.outNulls);
    }
}

