/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Supplier;
import it.unimi.dsi.fastutil.Hash;
import java.nio.ByteBuffer;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.AbstractSerializableLongObjectPairSerde;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.SerializablePairLongFloatColumnSerializer;
import org.apache.druid.query.aggregation.SerializablePairLongFloatComplexColumn;
import org.apache.druid.query.aggregation.SerializablePairLongFloatSimpleStagedSerde;
import org.apache.druid.segment.GenericColumnSerializer;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.ObjectStrategyComplexTypeStrategy;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.cell.NativeClearedByteBufferProvider;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class SerializablePairLongFloatComplexMetricSerde
extends AbstractSerializableLongObjectPairSerde<SerializablePairLongFloat> {
    public static final int EXPECTED_VERSION = 3;
    public static final String TYPE_NAME = "serializablePairLongFloat";
    private static final SerializablePairLongFloatSimpleStagedSerde SERDE = new SerializablePairLongFloatSimpleStagedSerde();
    private static final Comparator<SerializablePair<Long, Float>> COMPARATOR = SerializablePair.createNullHandlingComparator(Float::compare, true);

    public SerializablePairLongFloatComplexMetricSerde() {
        super(SerializablePairLongFloat.class);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public GenericColumnSerializer<SerializablePairLongFloat> getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column, IndexSpec indexSpec) {
        return new SerializablePairLongFloatColumnSerializer(segmentWriteOutMedium, NativeClearedByteBufferProvider.INSTANCE);
    }

    @Override
    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder columnBuilder) {
        SerializablePairLongFloatComplexColumn.Builder builder = new SerializablePairLongFloatComplexColumn.Builder(buffer).setByteBufferProvier(NativeClearedByteBufferProvider.INSTANCE);
        columnBuilder.setComplexColumnSupplier((Supplier<? extends ComplexColumn>)((Supplier)builder::build));
    }

    @Override
    public ObjectStrategy<SerializablePairLongFloat> getObjectStrategy() {
        return new ObjectStrategy<SerializablePairLongFloat>(){

            @Override
            public int compare(SerializablePairLongFloat o1, SerializablePairLongFloat o2) {
                return COMPARATOR.compare(o1, o2);
            }

            @Override
            public Class<? extends SerializablePairLongFloat> getClazz() {
                return SerializablePairLongFloat.class;
            }

            @Override
            public SerializablePairLongFloat fromByteBuffer(ByteBuffer buffer, int numBytes) {
                ByteBuffer readOnlyByteBuffer = buffer.asReadOnlyBuffer().order(buffer.order());
                readOnlyByteBuffer.limit(buffer.position() + numBytes);
                return SERDE.deserialize(readOnlyByteBuffer);
            }

            @Override
            public byte[] toBytes(@Nullable SerializablePairLongFloat inPair) {
                return SERDE.serialize(inPair);
            }

            @Override
            public boolean readRetainsBufferReference() {
                return false;
            }
        };
    }

    public TypeStrategy<SerializablePairLongFloat> getTypeStrategy() {
        return new ObjectStrategyComplexTypeStrategy<SerializablePairLongFloat>(this.getObjectStrategy(), ColumnType.ofComplex(this.getTypeName()), new Hash.Strategy<SerializablePairLongFloat>(){

            public int hashCode(SerializablePairLongFloat o) {
                return o.hashCode();
            }

            public boolean equals(SerializablePairLongFloat a, SerializablePairLongFloat b) {
                return a.equals(b);
            }
        });
    }
}

