/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.hyperloglog;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.hll.HyperLogLogHash;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class HyperUniquesSerde
extends ComplexMetricSerde {
    public static final String TYPE_NAME = "hyperUnique";
    private static Comparator<HyperLogLogCollector> comparator = Comparator.nullsFirst(Comparator.comparing(HyperLogLogCollector::toByteBuffer));
    private final HyperLogLogHash hyperLogLogHash;

    public HyperUniquesSerde() {
        this(HyperLogLogHash.getDefault());
    }

    public HyperUniquesSerde(HyperLogLogHash hyperLogLogHash) {
        this.hyperLogLogHash = hyperLogLogHash;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public ComplexMetricExtractor<HyperLogLogCollector> getExtractor() {
        return new ComplexMetricExtractor<HyperLogLogCollector>(){

            @Override
            public Class<HyperLogLogCollector> extractedClass() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue instanceof HyperLogLogCollector) {
                    return (HyperLogLogCollector)rawValue;
                }
                HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                List<String> dimValues = inputRow.getDimension(metricName);
                if (dimValues == null) {
                    return collector;
                }
                for (String dimensionValue : dimValues) {
                    collector.add(HyperUniquesSerde.this.hyperLogLogHash.hash(dimensionValue));
                }
                return collector;
            }
        };
    }

    @Override
    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<HyperLogLogCollector>(){

            @Override
            public Class<HyperLogLogCollector> getClazz() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector fromByteBuffer(ByteBuffer buffer, int numBytes) {
                ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
                readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
                return HyperLogLogCollector.makeCollector(readOnlyBuffer);
            }

            @Override
            public byte[] toBytes(HyperLogLogCollector collector) {
                if (collector == null) {
                    return new byte[0];
                }
                ByteBuffer val = collector.toByteBuffer();
                byte[] retVal = new byte[val.remaining()];
                val.asReadOnlyBuffer().get(retVal);
                return retVal;
            }

            @Override
            public int compare(HyperLogLogCollector o1, HyperLogLogCollector o2) {
                return comparator.compare(o1, o2);
            }
        };
    }
}

