/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongUnivariateLongFunctionVectorProcessor;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.chrono.ISOChronology;

public class TimestampShiftExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_shift";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 3, 4);
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampShiftExpr(this, args);
        }
        return new TimestampShiftDynamicExpr(this, args);
    }

    private static Period getPeriod(List<Expr> args, Expr.ObjectBinding bindings) {
        return new Period((Object)args.get(1).eval(bindings).asString());
    }

    private static int getStep(List<Expr> args, Expr.ObjectBinding bindings) {
        return args.get(2).eval(bindings).asInt();
    }

    private static ISOChronology getTimeZone(List<Expr> args, Expr.ObjectBinding bindings) {
        Expr timeZoneArg;
        Expr expr = timeZoneArg = args.size() > 3 ? args.get(3) : null;
        if (timeZoneArg == null) {
            return ISOChronology.getInstance(null);
        }
        String zone = timeZoneArg.eval(bindings).asString();
        return ISOChronology.getInstance((DateTimeZone)(zone != null ? DateTimes.inferTzFromString(zone) : null));
    }

    private static class TimestampShiftExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final Chronology chronology;
        private final Period period;
        private final int step;

        TimestampShiftExpr(TimestampShiftExprMacro macro, List<Expr> args) {
            super(macro, args);
            this.period = TimestampShiftExprMacro.getPeriod(args, InputBindings.nilBindings());
            this.chronology = TimestampShiftExprMacro.getTimeZone(args, InputBindings.nilBindings());
            this.step = TimestampShiftExprMacro.getStep(args, InputBindings.nilBindings());
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval timestamp = ((Expr)this.args.get(0)).eval(bindings);
            if (timestamp.isNumericNull()) {
                return ExprEval.of(null);
            }
            return ExprEval.of(this.chronology.add((ReadablePeriod)this.period, timestamp.asLong(), this.step));
        }

        @Override
        public boolean canVectorize(Expr.InputBindingInspector inspector) {
            return ((Expr)this.args.get(0)).canVectorize(inspector);
        }

        @Override
        public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
            LongUnivariateLongFunctionVectorProcessor processor = new LongUnivariateLongFunctionVectorProcessor(CastToTypeVectorProcessor.cast(((Expr)this.args.get(0)).asVectorProcessor(inspector), ExpressionType.LONG), input -> this.chronology.add((ReadablePeriod)this.period, input, this.step));
            return processor;
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }
    }

    private static class TimestampShiftDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampShiftDynamicExpr(TimestampShiftExprMacro macro, List<Expr> args) {
            super(macro, args);
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval timestamp = ((Expr)this.args.get(0)).eval(bindings);
            if (timestamp.isNumericNull()) {
                return ExprEval.of(null);
            }
            Period period = TimestampShiftExprMacro.getPeriod(this.args, bindings);
            ISOChronology chronology = TimestampShiftExprMacro.getTimeZone(this.args, bindings);
            int step = TimestampShiftExprMacro.getStep(this.args, bindings);
            return ExprEval.of(chronology.add((ReadablePeriod)period, timestamp.asLong(), step));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }
    }
}

