/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;

public class MultiValueStringVectorValueMatcher
implements VectorValueMatcherFactory {
    private final MultiValueDimensionVectorSelector selector;

    public MultiValueStringVectorValueMatcher(MultiValueDimensionVectorSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(final @Nullable String value) {
        IdLookup idLookup = this.selector.idLookup();
        if (idLookup != null) {
            boolean hasNull;
            final int id = idLookup.lookupId(value);
            boolean bl = hasNull = this.selector.lookupName(0) == null;
            if (id < 0) {
                return VectorValueMatcher.allFalseMultiValueDimensionMatcher(this.selector);
            }
            return new BaseVectorValueMatcher(this.selector){
                final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                    IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        IndexedInts ints = vector[rowNum];
                        int n = ints.size();
                        if (n == 0) {
                            if (value != null && !includeUnknown) continue;
                            selection[numRows++] = rowNum;
                            continue;
                        }
                        for (int j = 0; j < n; ++j) {
                            int rowId = ints.get(j);
                            if ((!hasNull || !includeUnknown || rowId != 0) && rowId != id) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                    }
                    this.match.setSelectionSize(numRows);
                    return this.match;
                }
            };
        }
        return this.makeMatcher(value == null ? DruidObjectPredicate.isNull() : DruidObjectPredicate.equalTo(value));
    }

    @Override
    public VectorValueMatcher makeMatcher(Object matchValue, ColumnType matchValueType) {
        ExprEval eval = ExprEval.ofType(ExpressionType.fromColumnType(matchValueType), matchValue);
        ExprEval<?> castForComparison = ExprEval.castForEqualityComparison(eval, ExpressionType.STRING);
        if (castForComparison == null) {
            return VectorValueMatcher.allFalseMultiValueDimensionMatcher(this.selector);
        }
        return this.makeMatcher(castForComparison.asString());
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        return this.makeMatcher(predicateFactory.makeStringPredicate());
    }

    private VectorValueMatcher makeMatcher(final DruidObjectPredicate<String> predicate) {
        if (this.selector.getValueCardinality() > 0) {
            final BitSet checkedIds = new BitSet(this.selector.getValueCardinality());
            final BitSet matchingIds = new BitSet(this.selector.getValueCardinality());
            return new BaseVectorValueMatcher(this.selector){
                private final VectorMatch match;
                {
                    super(selector);
                    this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
                }

                @Override
                public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                    IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                    int[] selection = this.match.getSelection();
                    int numRows = 0;
                    block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int rowNum = mask.getSelection()[i];
                        IndexedInts ints = vector[rowNum];
                        int n = ints.size();
                        if (n == 0) {
                            if (!predicate.apply(null).matches(includeUnknown)) continue;
                            selection[numRows++] = rowNum;
                            continue;
                        }
                        for (int j = 0; j < n; ++j) {
                            boolean matches;
                            int id = ints.get(j);
                            if (checkedIds.get(id)) {
                                matches = matchingIds.get(id);
                            } else {
                                String val = MultiValueStringVectorValueMatcher.this.selector.lookupName(id);
                                matches = predicate.apply(val).matches(includeUnknown);
                                checkedIds.set(id);
                                if (matches) {
                                    matchingIds.set(id);
                                }
                            }
                            if (!matches) continue;
                            selection[numRows++] = rowNum;
                            continue block0;
                        }
                    }
                    this.match.setSelectionSize(numRows);
                    return this.match;
                }
            };
        }
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[MultiValueStringVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                IndexedInts[] vector = MultiValueStringVectorValueMatcher.this.selector.getRowVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                block0: for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    IndexedInts ints = vector[rowNum];
                    int n = ints.size();
                    if (n == 0) {
                        if (!predicate.apply(null).matches(includeUnknown)) continue;
                        selection[numRows++] = rowNum;
                        continue;
                    }
                    for (int j = 0; j < n; ++j) {
                        int id = ints.get(j);
                        String val = MultiValueStringVectorValueMatcher.this.selector.lookupName(id);
                        if (!predicate.apply(val).matches(includeUnknown)) continue;
                        selection[numRows++] = rowNum;
                        continue block0;
                    }
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }
        };
    }
}

