/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.query.QueryResourceId;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryResources;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.GroupingEngine;

public class GroupByResourcesReservationPool {
    private final ConcurrentHashMap<QueryResourceId, AtomicReference<GroupByQueryResources>> pool = new ConcurrentHashMap();
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final GroupByQueryConfig groupByQueryConfig;

    @Inject
    public GroupByResourcesReservationPool(@Merging BlockingPool<ByteBuffer> mergeBufferPool, GroupByQueryConfig groupByQueryConfig) {
        this.mergeBufferPool = mergeBufferPool;
        this.groupByQueryConfig = groupByQueryConfig;
    }

    public void reserve(QueryResourceId queryResourceId, GroupByQuery groupByQuery, boolean willMergeRunner, GroupByStatsProvider.PerQueryStats perQueryStats) {
        GroupByQueryResources resources;
        long startNs = System.nanoTime();
        if (queryResourceId == null) {
            throw DruidException.defensive("Query resource id must be populated", new Object[0]);
        }
        AtomicReference<Object> reference = new AtomicReference<Object>(null);
        AtomicReference<Object> existingResource = this.pool.putIfAbsent(queryResourceId, reference);
        if (existingResource != null) {
            throw DruidException.defensive("Resource with the given identifier [%s] is already present", queryResourceId);
        }
        try {
            resources = GroupingEngine.prepareResource(groupByQuery, this.mergeBufferPool, willMergeRunner, this.groupByQueryConfig);
        }
        catch (Throwable t) {
            this.pool.remove(queryResourceId);
            throw t;
        }
        reference.compareAndSet(null, resources);
        perQueryStats.mergeBufferAcquisitionTime(System.nanoTime() - startNs);
    }

    @Nullable
    public GroupByQueryResources fetch(QueryResourceId queryResourceId) {
        AtomicReference<GroupByQueryResources> resourcesReference = this.pool.get(queryResourceId);
        if (resourcesReference == null) {
            return null;
        }
        GroupByQueryResources resource = resourcesReference.get();
        if (resource == null) {
            throw DruidException.defensive("Query id [%s] had a non-null reference in the resource reservation pool, but no resources were found", queryResourceId);
        }
        return resource;
    }

    public void clean(QueryResourceId queryResourceId) {
        AtomicReference<GroupByQueryResources> resourcesReference = this.pool.remove(queryResourceId);
        if (resourcesReference != null) {
            GroupByQueryResources resource = resourcesReference.get();
            if (resource == null) {
                throw DruidException.defensive("Query id [%s] had a non-null reference in the resource reservation pool, but no resources were found", queryResourceId);
            }
            resource.close();
        }
    }
}

