/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.io.IOException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;

public class SequenceOperator
implements Operator {
    private static final Logger log = new Logger(SequenceOperator.class);
    private final Sequence<RowsAndColumns> child;

    public SequenceOperator(Sequence<RowsAndColumns> child) {
        this.child = child;
    }

    @Override
    public Closeable goOrContinue(Closeable continuation, Operator.Receiver receiver) {
        Yielder<RowsAndColumns> yielder = null;
        try {
            Operator.Signal signal;
            yielder = continuation == null ? Yielders.each(this.child) : (Yielder<RowsAndColumns>)continuation;
            block11: while (true) {
                if (yielder.isDone()) {
                    if (yielder.get() != null) {
                        throw new ISE("Got a non-null get()[%s] even though we were already done.", yielder.get().getClass());
                    }
                    signal = Operator.Signal.STOP;
                } else {
                    signal = receiver.push(yielder.get());
                }
                if (signal != Operator.Signal.STOP && (yielder = yielder.next(null)).isDone()) {
                    signal = Operator.Signal.STOP;
                }
                switch (signal) {
                    case STOP: {
                        receiver.completed();
                        try {
                            yielder.close();
                        }
                        catch (IOException e) {
                            log.warn(e, "Exception thrown when closing yielder.  Logging and ignoring because results should be fine.", new Object[0]);
                        }
                        return null;
                    }
                    case PAUSE: {
                        return yielder;
                    }
                    case GO: {
                        continue block11;
                    }
                }
                break;
            }
            throw new ISE("Unknown signal[%s]", new Object[]{signal});
        }
        catch (RuntimeException re) {
            try {
                if (yielder != null) {
                    yielder.close();
                } else if (continuation != null) {
                    continuation.close();
                }
            }
            catch (IOException ioEx) {
                re.addSuppressed(ioEx);
            }
            throw re;
        }
    }
}

