/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BinaryOperator;
import org.apache.druid.java.util.common.granularity.AllGranularity;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.Result;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchResultValue;
import org.apache.druid.query.search.SearchSortSpec;
import org.joda.time.DateTime;

public class SearchBinaryFn
implements BinaryOperator<Result<SearchResultValue>> {
    private final SearchSortSpec searchSortSpec;
    private final Granularity gran;
    private final int limit;

    public SearchBinaryFn(SearchSortSpec searchSortSpec, Granularity granularity, int limit) {
        this.searchSortSpec = searchSortSpec;
        this.gran = granularity;
        this.limit = limit;
    }

    @Override
    public Result<SearchResultValue> apply(Result<SearchResultValue> arg1, Result<SearchResultValue> arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        int limit = this.gran instanceof AllGranularity ? this.limit : -1;
        SearchResultValue arg1Vals = arg1.getValue();
        SearchResultValue arg2Vals = arg2.getValue();
        Iterable merged = Iterables.mergeSorted(Arrays.asList(arg1Vals, arg2Vals), this.searchSortSpec.getComparator());
        int maxSize = arg1Vals.getValue().size() + arg2Vals.getValue().size();
        if (limit > 0) {
            maxSize = Math.min(limit, maxSize);
        }
        ArrayList results = Lists.newArrayListWithExpectedSize((int)maxSize);
        SearchHit prev = null;
        for (SearchHit searchHit : merged) {
            if (prev == null) {
                prev = searchHit;
                continue;
            }
            if (prev.equals(searchHit)) {
                if (prev.getCount() != null && searchHit.getCount() != null) {
                    prev = new SearchHit(prev.getDimension(), prev.getValue(), prev.getCount() + searchHit.getCount());
                    continue;
                }
                prev = new SearchHit(prev.getDimension(), prev.getValue());
                continue;
            }
            results.add(prev);
            prev = searchHit;
            if (limit <= 0 || results.size() < limit) continue;
            break;
        }
        if (prev != null && (limit < 0 || results.size() < limit)) {
            results.add(prev);
        }
        DateTime timestamp = this.gran instanceof AllGranularity ? arg1.getTimestamp() : this.gran.bucketStart(arg1.getTimestamp());
        return new Result<SearchResultValue>(timestamp, new SearchResultValue(results));
    }
}

