/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.logger.Logger;

public class DefaultColumnFormatConfig {
    private static final Logger LOG = new Logger(DefaultColumnFormatConfig.class);
    @Nullable
    @JsonProperty(value="nestedColumnFormatVersion")
    private final Integer nestedColumnFormatVersion;
    @Nullable
    @JsonProperty(value="stringMultiValueHandlingMode")
    private final String stringMultiValueHandlingMode;

    public static void validateNestedFormatVersion(@Nullable Integer formatVersion) {
        if (formatVersion != null && formatVersion != 5) {
            LOG.warn("Unsupported nested column format version[%s], using default version instead", formatVersion);
        }
    }

    private static void validateMultiValueHandlingMode(@Nullable String stringMultiValueHandlingMode) {
        if (stringMultiValueHandlingMode != null) {
            try {
                DimensionSchema.MultiValueHandling.fromString(stringMultiValueHandlingMode);
            }
            catch (IllegalArgumentException e) {
                throw DruidException.forPersona(DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.INVALID_INPUT).build("Invalid value[%s] specified for 'druid.indexing.formats.stringMultiValueHandlingMode'. Supported values are [%s].", stringMultiValueHandlingMode, Arrays.toString((Object[])DimensionSchema.MultiValueHandling.values()));
            }
        }
    }

    @JsonCreator
    public DefaultColumnFormatConfig(@JsonProperty(value="nestedColumnFormatVersion") @Nullable Integer nestedColumnFormatVersion, @JsonProperty(value="stringMultiValueHandlingMode") @Nullable String stringMultiValueHandlingMode) {
        DefaultColumnFormatConfig.validateNestedFormatVersion(nestedColumnFormatVersion);
        DefaultColumnFormatConfig.validateMultiValueHandlingMode(stringMultiValueHandlingMode);
        this.nestedColumnFormatVersion = nestedColumnFormatVersion;
        this.stringMultiValueHandlingMode = stringMultiValueHandlingMode;
    }

    @Nullable
    @JsonProperty(value="nestedColumnFormatVersion")
    public Integer getNestedColumnFormatVersion() {
        return this.nestedColumnFormatVersion;
    }

    @Nullable
    @JsonProperty(value="stringMultiValueHandlingMode")
    public String getStringMultiValueHandlingMode() {
        return this.stringMultiValueHandlingMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultColumnFormatConfig that = (DefaultColumnFormatConfig)o;
        return Objects.equals(this.nestedColumnFormatVersion, that.nestedColumnFormatVersion) && Objects.equals(this.stringMultiValueHandlingMode, that.stringMultiValueHandlingMode);
    }

    public int hashCode() {
        return Objects.hash(this.nestedColumnFormatVersion, this.stringMultiValueHandlingMode);
    }

    public String toString() {
        return "DefaultColumnFormatConfig{nestedColumnFormatVersion=" + this.nestedColumnFormatVersion + ", stringMultiValueHandlingMode=" + this.stringMultiValueHandlingMode + "}";
    }
}

