/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.segment.data.Indexed;

public class DictionaryMergingIterator<T extends Comparable<T>>
implements CloseableIterator<T> {
    private static final Logger log = new Logger(DictionaryMergingIterator.class);
    protected final IntBuffer[] conversions;
    protected final List<Pair<ByteBuffer, Integer>> directBufferAllocations = new ArrayList<Pair<ByteBuffer, Integer>>();
    protected final PriorityQueue<Pair<Integer, PeekingIterator<T>>> pQueue;
    protected int counter;

    public static <T extends Comparable<T>> Comparator<Pair<Integer, PeekingIterator<T>>> makePeekingComparator() {
        return (lhs, rhs) -> {
            Comparable left = (Comparable)((PeekingIterator)lhs.rhs).peek();
            Comparable right = (Comparable)((PeekingIterator)rhs.rhs).peek();
            if (left == null) {
                return right == null ? 0 : -1;
            }
            if (right == null) {
                return 1;
            }
            return left.compareTo(right);
        };
    }

    public DictionaryMergingIterator(Indexed<T>[] dimValueLookups, Comparator<Pair<Integer, PeekingIterator<T>>> comparator, boolean useDirect) {
        this.pQueue = new PriorityQueue<Pair<Integer, PeekingIterator<T>>>(dimValueLookups.length, comparator);
        this.conversions = new IntBuffer[dimValueLookups.length];
        long mergeBufferTotalSize = 0L;
        for (int i = 0; i < this.conversions.length; ++i) {
            if (dimValueLookups[i] == null) continue;
            Indexed<T> indexed = dimValueLookups[i];
            if (useDirect) {
                int allocationSize = indexed.size() * 4;
                log.trace("Allocating dictionary merging direct buffer with size[%,d]", allocationSize);
                mergeBufferTotalSize += (long)allocationSize;
                ByteBuffer conversionDirectBuffer = ByteBuffer.allocateDirect(allocationSize);
                this.conversions[i] = conversionDirectBuffer.asIntBuffer();
                this.directBufferAllocations.add(new Pair<ByteBuffer, Integer>(conversionDirectBuffer, allocationSize));
            } else {
                this.conversions[i] = IntBuffer.allocate(indexed.size());
                mergeBufferTotalSize += (long)indexed.size();
            }
            PeekingIterator<T> iter = this.transformIndexedIterator(indexed);
            if (!iter.hasNext()) continue;
            this.pQueue.add(Pair.of(i, iter));
        }
        log.debug("Allocated [%,d] bytes of dictionary merging direct buffers", mergeBufferTotalSize);
    }

    @Override
    public boolean hasNext() {
        return !this.pQueue.isEmpty();
    }

    @Override
    public T next() {
        Pair smallest = (Pair)this.pQueue.remove();
        if (smallest == null) {
            throw new NoSuchElementException();
        }
        T value = this.writeTranslate(smallest, this.counter);
        while (!this.pQueue.isEmpty() && Objects.equals(value, ((PeekingIterator)this.pQueue.peek().rhs).peek())) {
            this.writeTranslate((Pair)this.pQueue.remove(), this.counter);
        }
        ++this.counter;
        return value;
    }

    public int getCardinality() {
        return this.counter;
    }

    protected PeekingIterator<T> transformIndexedIterator(Indexed<T> indexed) {
        return Iterators.peekingIterator(indexed.iterator());
    }

    protected boolean needConversion(int index) {
        IntBuffer readOnly = this.conversions[index].asReadOnlyBuffer();
        readOnly.rewind();
        int i = 0;
        while (readOnly.hasRemaining()) {
            if (i != readOnly.get()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected T writeTranslate(Pair<Integer, PeekingIterator<T>> smallest, int counter) {
        int index = (Integer)smallest.lhs;
        Comparable value = (Comparable)((PeekingIterator)smallest.rhs).next();
        this.conversions[index].put(counter);
        if (((PeekingIterator)smallest.rhs).hasNext()) {
            this.pQueue.add(smallest);
        }
        return (T)value;
    }

    @Override
    public void close() {
        long mergeBufferTotalSize = 0L;
        for (Pair<ByteBuffer, Integer> bufferAllocation : this.directBufferAllocations) {
            log.trace("Freeing dictionary merging direct buffer with size[%,d]", bufferAllocation.rhs);
            mergeBufferTotalSize += (long)((Integer)bufferAllocation.rhs).intValue();
            ByteBufferUtils.free((ByteBuffer)bufferAllocation.lhs);
        }
        log.debug("Freed [%,d] bytes of dictionary merging direct buffers", mergeBufferTotalSize);
    }
}

