/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.data.BitmapValues;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.ImmutableBitmapValues;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.nested.NestedCommonFormatColumn;
import org.apache.druid.segment.nested.NestedDataComplexTypeSerde;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableLongColumnValueSelector;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class QueryableIndexIndexableAdapter
implements IndexableAdapter {
    private final int numRows;
    private final QueryableIndex input;
    private final ImmutableList<String> availableDimensions;
    private final Metadata metadata;
    private final int timePositionForComparator;

    public QueryableIndexIndexableAdapter(QueryableIndex input) {
        this.input = input;
        this.numRows = input.getNumRows();
        this.availableDimensions = ImmutableList.copyOf(input.getAvailableDimensions());
        if (this.availableDimensions.contains((Object)"__time")) {
            throw DruidException.defensive("Unexpectedly encountered dimension[%s]", "__time");
        }
        this.metadata = input.getMetadata();
        List<OrderBy> inputOrdering = input.getOrdering();
        int foundTimePosition = -1;
        int i = 0;
        for (OrderBy orderBy : inputOrdering) {
            String columnName = orderBy.getColumnName();
            if (orderBy.getOrder() != Order.ASCENDING) {
                throw DruidException.defensive("Order[%s] for column[%s] is not supported", new Object[]{orderBy.getOrder(), columnName});
            }
            if ("__time".equals(columnName)) {
                foundTimePosition = i;
                break;
            }
            if (!input.getDimensionHandlers().containsKey(columnName)) continue;
            ++i;
        }
        this.timePositionForComparator = foundTimePosition >= 0 ? foundTimePosition : inputOrdering.size();
    }

    public QueryableIndex getQueryableIndex() {
        return this.input;
    }

    @Override
    public Interval getDataInterval() {
        return this.input.getDataInterval();
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public List<String> getDimensionNames(boolean includeTime) {
        if (includeTime) {
            ArrayList<String> retVal = new ArrayList<String>(this.availableDimensions.size() + 1);
            retVal.add("__time");
            retVal.addAll((Collection<String>)this.availableDimensions);
            return retVal;
        }
        return this.availableDimensions;
    }

    @Override
    public List<String> getMetricNames() {
        LinkedHashSet columns = Sets.newLinkedHashSet(this.input.getColumnNames());
        HashSet dimensions = Sets.newHashSet(this.availableDimensions);
        return ImmutableList.copyOf((Collection)Sets.difference((Set)columns, (Set)dimensions));
    }

    @Override
    @Nullable
    public <T extends Comparable<? super T>> CloseableIndexed<T> getDimValueLookup(String dimension) {
        ColumnHolder columnHolder = this.input.getColumnHolder(dimension);
        if (columnHolder == null) {
            return null;
        }
        BaseColumn col = columnHolder.getColumn();
        if (!(col instanceof DictionaryEncodedColumn)) {
            try {
                col.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return null;
        }
        final DictionaryEncodedColumn dict = (DictionaryEncodedColumn)col;
        return new CloseableIndexed<T>(){

            @Override
            public int size() {
                return dict.getCardinality();
            }

            @Override
            public T get(int index) {
                return dict.lookupName(index);
            }

            @Override
            public int indexOf(T value) {
                return dict.lookupId(value);
            }

            @Override
            public Iterator<T> iterator() {
                return IndexedIterable.create(this).iterator();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("dict", dict);
            }

            @Override
            public void close() throws IOException {
                dict.close();
            }
        };
    }

    @Override
    @Nullable
    public IndexableAdapter.NestedColumnMergable getNestedColumnMergeables(String columnName) {
        ColumnHolder columnHolder = this.input.getColumnHolder(columnName);
        if (columnHolder == null) {
            return null;
        }
        ColumnFormat format = columnHolder.getColumnFormat();
        if (!(format instanceof NestedCommonFormatColumn.Format) && !(format instanceof NestedDataComplexTypeSerde.NestedColumnFormatV4)) {
            return null;
        }
        BaseColumn col = columnHolder.getColumn();
        if (col instanceof NestedCommonFormatColumn) {
            NestedCommonFormatColumn column = (NestedCommonFormatColumn)col;
            return new IndexableAdapter.NestedColumnMergable(new SortedValueDictionary(column.getStringDictionary(), column.getLongDictionary(), column.getDoubleDictionary(), column.getArrayDictionary(), column), column.getFieldTypeInfo(), ColumnType.NESTED_DATA.equals(column.getLogicalType()), false, null);
        }
        try {
            col.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public RowIteratorImpl getRows() {
        return new RowIteratorImpl();
    }

    @Override
    public IndexableAdapter getProjectionAdapter(String projection) {
        QueryableIndex projectionIndex = this.input.getProjectionQueryableIndex(projection);
        DruidException.conditionalDefensive(projectionIndex != null, "Projection[%s] was not found", projection);
        return new QueryableIndexIndexableAdapter(projectionIndex);
    }

    @Override
    public ColumnCapabilities getCapabilities(String column) {
        return this.input.getColumnHolder(column).getCapabilities();
    }

    @Override
    public ColumnFormat getFormat(String column) {
        return this.input.getColumnHolder(column).getColumnFormat();
    }

    @Override
    public BitmapValues getBitmapValues(String dimension, int dictId) {
        ColumnHolder columnHolder = this.input.getColumnHolder(dimension);
        if (columnHolder == null) {
            return BitmapValues.EMPTY;
        }
        ColumnIndexSupplier indexSupplier = columnHolder.getIndexSupplier();
        if (indexSupplier == null) {
            return BitmapValues.EMPTY;
        }
        DictionaryEncodedValueIndex bitmaps = indexSupplier.as(DictionaryEncodedValueIndex.class);
        if (bitmaps == null) {
            return BitmapValues.EMPTY;
        }
        if (dictId >= 0) {
            return new ImmutableBitmapValues(bitmaps.getBitmap(dictId));
        }
        return BitmapValues.EMPTY;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    class RowIteratorImpl
    implements TransformableRowIterator {
        private final Closer closer;
        private final ColumnCache columnCache;
        private final SimpleAscendingOffset offset;
        private final int maxValidOffset;
        private final ColumnValueSelector<?> offsetTimestampSelector;
        private final ColumnValueSelector<?>[] offsetDimensionValueSelectors;
        private final ColumnValueSelector<?>[] offsetMetricSelectors;
        private final SettableLongColumnValueSelector rowTimestampSelector;
        private final SettableColumnValueSelector<?>[] rowDimensionValueSelectors;
        private final SettableColumnValueSelector<?>[] rowMetricSelectors;
        private final RowPointer rowPointer;
        private final SettableLongColumnValueSelector markedTimestampSelector;
        private final SettableColumnValueSelector<?>[] markedDimensionValueSelectors;
        private final SettableColumnValueSelector<?>[] markedMetricSelectors;
        private final TimeAndDimsPointer markedRowPointer;
        boolean first;

        RowIteratorImpl() {
            this.offset = new SimpleAscendingOffset(QueryableIndexIndexableAdapter.this.numRows);
            this.maxValidOffset = QueryableIndexIndexableAdapter.this.numRows - 1;
            this.rowTimestampSelector = new SettableLongColumnValueSelector();
            this.markedTimestampSelector = new SettableLongColumnValueSelector();
            this.first = true;
            this.closer = Closer.create();
            this.columnCache = new ColumnCache(QueryableIndexIndexableAdapter.this.input, this.closer);
            QueryableIndexColumnSelectorFactory columnSelectorFactory = new QueryableIndexColumnSelectorFactory(VirtualColumns.EMPTY, QueryableIndexIndexableAdapter.this.timePositionForComparator == 0 ? Order.ASCENDING : Order.NONE, this.offset, this.columnCache);
            this.offsetTimestampSelector = columnSelectorFactory.makeColumnValueSelector("__time");
            ArrayList<DimensionHandler> dimensionHandlers = new ArrayList<DimensionHandler>(QueryableIndexIndexableAdapter.this.input.getDimensionHandlers().values());
            this.offsetDimensionValueSelectors = (ColumnValueSelector[])dimensionHandlers.stream().map(DimensionHandler::getDimensionName).map(columnSelectorFactory::makeColumnValueSelector).toArray(ColumnValueSelector[]::new);
            List<String> metricNames = QueryableIndexIndexableAdapter.this.getMetricNames();
            this.offsetMetricSelectors = (ColumnValueSelector[])metricNames.stream().map(columnSelectorFactory::makeColumnValueSelector).toArray(ColumnValueSelector[]::new);
            this.rowDimensionValueSelectors = (SettableColumnValueSelector[])dimensionHandlers.stream().map(DimensionHandler::makeNewSettableEncodedValueSelector).toArray(SettableColumnValueSelector[]::new);
            this.rowMetricSelectors = (SettableColumnValueSelector[])metricNames.stream().map(metric -> QueryableIndexIndexableAdapter.this.input.getColumnHolder((String)metric).makeNewSettableColumnValueSelector()).toArray(SettableColumnValueSelector[]::new);
            this.rowPointer = new RowPointer(this.rowTimestampSelector, QueryableIndexIndexableAdapter.this.timePositionForComparator, this.rowDimensionValueSelectors, dimensionHandlers, this.rowMetricSelectors, metricNames, this.offset::getOffset);
            this.markedDimensionValueSelectors = (SettableColumnValueSelector[])dimensionHandlers.stream().map(DimensionHandler::makeNewSettableEncodedValueSelector).toArray(SettableColumnValueSelector[]::new);
            this.markedMetricSelectors = (SettableColumnValueSelector[])metricNames.stream().map(metric -> QueryableIndexIndexableAdapter.this.input.getColumnHolder((String)metric).makeNewSettableColumnValueSelector()).toArray(SettableColumnValueSelector[]::new);
            this.markedRowPointer = new TimeAndDimsPointer(this.markedTimestampSelector, QueryableIndexIndexableAdapter.this.timePositionForComparator, this.markedDimensionValueSelectors, dimensionHandlers, this.markedMetricSelectors, metricNames);
        }

        @Override
        public TimeAndDimsPointer getMarkedPointer() {
            return this.markedRowPointer;
        }

        @Override
        public boolean hasTimeAndDimsChangedSinceMark() {
            return this.markedRowPointer.compareTo(this.rowPointer) != 0;
        }

        @Override
        public void close() {
            CloseableUtils.closeAndWrapExceptions(this.closer);
        }

        @Override
        public RowPointer getPointer() {
            return this.rowPointer;
        }

        @Override
        public boolean moveToNext() {
            if (this.first) {
                this.first = false;
                if (this.offset.withinBounds()) {
                    this.setRowPointerValues();
                    return true;
                }
                return false;
            }
            if (this.offset.getOffset() < this.maxValidOffset) {
                this.offset.increment();
                this.setRowPointerValues();
                return true;
            }
            return false;
        }

        private void setRowPointerValues() {
            int i;
            this.rowTimestampSelector.setValue(this.offsetTimestampSelector.getLong());
            for (i = 0; i < this.offsetDimensionValueSelectors.length; ++i) {
                this.rowDimensionValueSelectors[i].setValueFrom(this.offsetDimensionValueSelectors[i]);
            }
            for (i = 0; i < this.offsetMetricSelectors.length; ++i) {
                this.rowMetricSelectors[i].setValueFrom(this.offsetMetricSelectors[i]);
            }
        }

        @Override
        public void mark() {
            int i;
            this.markedTimestampSelector.setValue(this.rowTimestampSelector.getLong());
            for (i = 0; i < this.rowDimensionValueSelectors.length; ++i) {
                this.markedDimensionValueSelectors[i].setValueFrom(this.rowDimensionValueSelectors[i]);
            }
            for (i = 0; i < this.rowMetricSelectors.length; ++i) {
                this.markedMetricSelectors[i].setValueFrom(this.rowMetricSelectors[i]);
            }
        }
    }
}

