/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.SimpleSequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.OrderBy;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.RowBasedCursor;
import org.apache.druid.segment.RowWalker;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class RowBasedCursorFactory<RowType>
implements CursorFactory {
    private final Sequence<RowType> rowSequence;
    private final RowAdapter<RowType> rowAdapter;
    private final RowSignature rowSignature;

    public RowBasedCursorFactory(Sequence<RowType> rowSequence, RowAdapter<RowType> rowAdapter, RowSignature rowSignature) {
        this.rowSequence = rowSequence;
        this.rowAdapter = rowAdapter;
        this.rowSignature = rowSignature;
    }

    @Override
    public CursorHolder makeCursorHolder(final CursorBuildSpec spec) {
        boolean descending;
        List<OrderBy> ordering;
        if (Cursors.preferDescendingTimeOrdering(spec)) {
            ordering = Cursors.descendingTimeOrder();
            descending = true;
        } else {
            ordering = Cursors.ascendingTimeOrder();
            descending = false;
        }
        return new CursorHolder(){
            final Closer closer = Closer.create();

            @Override
            public Cursor asCursor() {
                RowWalker rowWalker = this.closer.register(new RowWalker(descending ? RowBasedCursorFactory.reverse(RowBasedCursorFactory.this.rowSequence) : RowBasedCursorFactory.this.rowSequence, RowBasedCursorFactory.this.rowAdapter));
                return new RowBasedCursor(rowWalker, RowBasedCursorFactory.this.rowAdapter, spec.getFilter(), spec.getInterval(), spec.getVirtualColumns(), descending, RowBasedCursorFactory.this.rowSignature);
            }

            @Override
            @Nullable
            public List<OrderBy> getOrdering() {
                return ordering;
            }

            @Override
            public void close() {
                CloseableUtils.closeAndWrapExceptions(this.closer);
            }
        };
    }

    @Override
    public RowSignature getRowSignature() {
        return this.rowSignature;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return RowBasedColumnSelectorFactory.getColumnCapabilities(this.rowSignature, column);
    }

    private static <T> Sequence<T> reverse(Sequence<T> sequence) {
        if (sequence instanceof SimpleSequence) {
            return Sequences.simple(RowBasedCursorFactory.reverse(((SimpleSequence)sequence).getIterable()));
        }
        return Sequences.simple(Lists.reverse(sequence.toList()));
    }

    private static <T> Iterable<T> reverse(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return Lists.reverse((List)((List)iterable));
        }
        return Lists.reverse((List)Lists.newArrayList(iterable));
    }
}

