/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.VirtualColumn;

public class JoinFilterSplit {
    final Optional<Filter> baseTableFilter;
    final Optional<Filter> joinTableFilter;
    final Set<VirtualColumn> pushDownVirtualColumns;

    public JoinFilterSplit(@Nullable Filter baseTableFilter, @Nullable Filter joinTableFilter, Set<VirtualColumn> pushDownVirtualColumns) {
        this.baseTableFilter = baseTableFilter == null ? Optional.empty() : Optional.of(baseTableFilter);
        this.joinTableFilter = joinTableFilter == null ? Optional.empty() : Optional.of(joinTableFilter);
        this.pushDownVirtualColumns = pushDownVirtualColumns;
    }

    public Optional<Filter> getBaseTableFilter() {
        return this.baseTableFilter;
    }

    public Optional<Filter> getJoinTableFilter() {
        return this.joinTableFilter;
    }

    public Set<VirtualColumn> getPushDownVirtualColumns() {
        return this.pushDownVirtualColumns;
    }

    public String toString() {
        return "JoinFilterSplit{baseTableFilter=" + String.valueOf(this.baseTableFilter) + ", joinTableFilter=" + String.valueOf(this.joinTableFilter) + ", pushDownVirtualColumns=" + String.valueOf(this.pushDownVirtualColumns) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinFilterSplit that = (JoinFilterSplit)o;
        return Objects.equals(this.getBaseTableFilter(), that.getBaseTableFilter()) && Objects.equals(this.getJoinTableFilter(), that.getJoinTableFilter()) && Objects.equals(this.getPushDownVirtualColumns(), that.getPushDownVirtualColumns());
    }

    public int hashCode() {
        return Objects.hash(this.getBaseTableFilter(), this.getJoinTableFilter(), this.getPushDownVirtualColumns());
    }
}

