/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class VariantArrayFieldColumnWriter
extends GlobalDictionaryEncodedFieldColumnWriter<int[]> {
    public VariantArrayFieldColumnWriter(String columnName, String fieldName, SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec, DictionaryIdLookup globalDictionaryIdLookup) {
        super(columnName, fieldName, segmentWriteOutMedium, indexSpec, globalDictionaryIdLookup);
    }

    @Override
    int[] processValue(int row, Object value) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int[] globalIds = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                globalIds[i] = array[i] == null ? 0 : (array[i] instanceof String ? this.globalDictionaryIdLookup.lookupString((String)array[i]) : (array[i] instanceof Long ? this.globalDictionaryIdLookup.lookupLong((Long)array[i]) : (array[i] instanceof Double ? this.globalDictionaryIdLookup.lookupDouble((Double)array[i]) : -1)));
                Preconditions.checkArgument((globalIds[i] >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (int)globalIds[i], (Object)array[i]);
                ((MutableBitmap)this.arrayElements.computeIfAbsent(globalIds[i], id -> this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap())).add(row);
            }
            return globalIds;
        }
        if (value != null) {
            throw new ISE("Value is not an array, got [%s] instead", value.getClass());
        }
        return null;
    }

    @Override
    int lookupGlobalId(int[] value) {
        return this.globalDictionaryIdLookup.lookupArray(value);
    }

    @Override
    void writeColumnTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeLongAndDoubleColumnLength(channel, 0, 0);
        this.encodedValueSerializer.writeTo(channel, smoosher);
    }
}

