/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedIntWriter;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.data.FrontCodedIntArrayIndexedWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class VariantColumnSerializer
extends NestedCommonFormatColumnSerializer {
    private static final Logger log = new Logger(VariantColumnSerializer.class);
    private final String name;
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final IndexSpec indexSpec;
    private final Closer closer;
    private DictionaryIdLookup dictionaryIdLookup;
    private DictionaryWriter<String> dictionaryWriter;
    private FixedIndexedWriter<Long> longDictionaryWriter;
    private FixedIndexedWriter<Double> doubleDictionaryWriter;
    private FrontCodedIntArrayIndexedWriter arrayDictionaryWriter;
    private FixedIndexedIntWriter arrayElementDictionaryWriter;
    private boolean closedForWrite = false;
    private boolean dictionarySerialized = false;
    private FixedIndexedIntWriter intermediateValueWriter;
    private boolean hasNulls;
    private boolean writeDictionary = true;
    @Nullable
    private final ExpressionType expectedExpressionType;
    @Nullable
    private final Byte variantTypeSetByte;
    private InternalSerializer internalSerializer = null;

    public VariantColumnSerializer(String name, @Nullable ColumnType logicalType, @Nullable Byte variantTypeSetByte, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.expectedExpressionType = logicalType != null ? ExpressionType.fromColumnTypeStrict(logicalType) : null;
        this.variantTypeSetByte = variantTypeSetByte;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.indexSpec = indexSpec;
        this.closer = closer;
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public DictionaryIdLookup getDictionaryIdLookup() {
        return this.dictionaryIdLookup;
    }

    @Override
    public void setDictionaryIdLookup(DictionaryIdLookup dictionaryIdLookup) {
        this.dictionaryIdLookup = dictionaryIdLookup;
        this.writeDictionary = false;
        this.dictionarySerialized = true;
    }

    @Override
    public boolean hasNulls() {
        return this.hasNulls;
    }

    @Override
    public void openDictionaryWriter(File segmentBaseDir) throws IOException {
        this.dictionaryWriter = StringEncodingStrategies.getStringDictionaryWriter(this.indexSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, this.name);
        this.dictionaryWriter.open();
        this.longDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.LONG.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.longDictionaryWriter.open();
        this.doubleDictionaryWriter = new FixedIndexedWriter(this.segmentWriteOutMedium, ColumnType.DOUBLE.getStrategy(), ByteOrder.nativeOrder(), 8, true);
        this.doubleDictionaryWriter.open();
        this.arrayDictionaryWriter = new FrontCodedIntArrayIndexedWriter(this.segmentWriteOutMedium, ByteOrder.nativeOrder(), 4);
        this.arrayDictionaryWriter.open();
        this.arrayElementDictionaryWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, true);
        this.arrayElementDictionaryWriter.open();
        this.dictionaryIdLookup = this.closer.register(new DictionaryIdLookup(this.name, segmentBaseDir, this.dictionaryWriter, this.longDictionaryWriter, this.doubleDictionaryWriter, this.arrayDictionaryWriter));
    }

    @Override
    public void open() throws IOException {
        if (!this.dictionarySerialized) {
            throw new IllegalStateException("Dictionary not serialized, cannot open value serializer");
        }
        this.intermediateValueWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, false);
        this.intermediateValueWriter.open();
    }

    @Override
    public void serializeDictionaries(Iterable<String> strings, Iterable<Long> longs, Iterable<Double> doubles, Iterable<int[]> arrays) throws IOException {
        if (this.dictionarySerialized) {
            throw new ISE("Value dictionaries already serialized for column [%s], cannot serialize again", this.name);
        }
        this.dictionaryWriter.write(null);
        for (String string : strings) {
            if (string == null) continue;
            this.dictionaryWriter.write(string);
        }
        for (Long l : longs) {
            if (l == null) continue;
            this.longDictionaryWriter.write(l);
        }
        for (Double d : doubles) {
            if (d == null) continue;
            this.doubleDictionaryWriter.write(d);
        }
        for (int[] nArray : arrays) {
            if (nArray == null) continue;
            this.arrayDictionaryWriter.write(nArray);
        }
        this.dictionarySerialized = true;
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        if (!this.dictionarySerialized) {
            throw new ISE("Must serialize value dictionaries before serializing values for column [%s]", this.name);
        }
        ExprEval eval = ExprEval.bestEffortOf(StructuredData.unwrap(selector.getObject()));
        if (this.expectedExpressionType != null) {
            try {
                eval = eval.castTo(this.expectedExpressionType);
            }
            catch (IAE invalidCast) {
                this.intermediateValueWriter.write(0);
                this.hasNulls = true;
                return;
            }
        }
        if (eval.isArray()) {
            Object[] array = eval.asArray();
            if (array == null) {
                this.intermediateValueWriter.write(0);
                this.hasNulls = true;
                return;
            }
            int[] globalIds = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                globalIds[i] = array[i] == null ? 0 : (array[i] instanceof String ? this.dictionaryIdLookup.lookupString((String)array[i]) : (array[i] instanceof Long ? this.dictionaryIdLookup.lookupLong((Long)array[i]) : (array[i] instanceof Double ? this.dictionaryIdLookup.lookupDouble((Double)array[i]) : -1)));
                Preconditions.checkArgument((globalIds[i] >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (int)globalIds[i], (Object)array[i]);
            }
            int dictId = this.dictionaryIdLookup.lookupArray(globalIds);
            this.intermediateValueWriter.write(dictId);
            this.hasNulls = this.hasNulls || dictId == 0;
        } else {
            Object o = eval.value();
            int dictId = o == null ? 0 : (o instanceof String ? this.dictionaryIdLookup.lookupString((String)o) : (o instanceof Long ? this.dictionaryIdLookup.lookupLong((Long)o) : (o instanceof Double ? this.dictionaryIdLookup.lookupDouble((Double)o) : -1)));
            Preconditions.checkArgument((dictId >= 0 ? 1 : 0) != 0, (String)"unknown global id [%s] for value [%s]", (int)dictId, o);
            this.intermediateValueWriter.write(dictId);
            this.hasNulls = this.hasNulls || dictId == 0;
        }
    }

    private void closeForWrite() throws IOException {
        if (!this.closedForWrite) {
            int i;
            String filenameBase = StringUtils.format("%s.forward_dim", this.name);
            int scalarCardinality = this.dictionaryIdLookup.getStringCardinality() + this.dictionaryIdLookup.getLongCardinality() + this.dictionaryIdLookup.getDoubleCardinality();
            int cardinality = scalarCardinality + this.dictionaryIdLookup.getArrayCardinality();
            CompressionStrategy compression = this.indexSpec.getDimensionCompression();
            CompressionStrategy compressionToUse = compression != CompressionStrategy.UNCOMPRESSED && compression != CompressionStrategy.NONE ? compression : CompressionStrategy.LZ4;
            CompressedVSizeColumnarIntsSerializer encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.name, this.segmentWriteOutMedium, filenameBase, cardinality, compressionToUse, this.segmentWriteOutMedium.getCloser());
            encodedValueSerializer.open();
            GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
            bitmapIndexWriter.open();
            bitmapIndexWriter.setObjectsNotSorted();
            MutableBitmap[] bitmaps = new MutableBitmap[cardinality];
            MutableBitmap[] arrayElements = new MutableBitmap[scalarCardinality];
            for (int i2 = 0; i2 < bitmaps.length; ++i2) {
                bitmaps[i2] = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
            }
            GenericIndexedWriter<ImmutableBitmap> arrayElementIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name + "_arrays", this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
            arrayElementIndexWriter.open();
            arrayElementIndexWriter.setObjectsNotSorted();
            IntIterator rows = this.intermediateValueWriter.getIterator();
            int rowCount = 0;
            int arrayBaseId = this.dictionaryIdLookup.getStringCardinality() + this.dictionaryIdLookup.getLongCardinality() + this.dictionaryIdLookup.getDoubleCardinality();
            while (rows.hasNext()) {
                int dictId = rows.nextInt();
                ((SingleValueColumnarIntsSerializer)encodedValueSerializer).addValue(dictId);
                bitmaps[dictId].add(rowCount);
                if (dictId >= arrayBaseId) {
                    int[] array;
                    for (int elementId : array = this.dictionaryIdLookup.getArrayValue(dictId)) {
                        MutableBitmap bitmap = arrayElements[elementId];
                        if (bitmap == null) {
                            arrayElements[elementId] = bitmap = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
                        }
                        bitmap.add(rowCount);
                    }
                }
                ++rowCount;
            }
            for (i = 0; i < bitmaps.length; ++i) {
                MutableBitmap bitmap = bitmaps[i];
                bitmapIndexWriter.write(this.indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeImmutableBitmap(bitmap));
                bitmaps[i] = null;
            }
            if (this.writeDictionary) {
                for (i = 0; i < arrayElements.length; ++i) {
                    if (arrayElements[i] == null) continue;
                    this.arrayElementDictionaryWriter.write(i);
                    arrayElementIndexWriter.write(arrayElements[i]);
                }
            }
            this.closedForWrite = true;
            this.internalSerializer = new InternalSerializer(this.name, this.variantTypeSetByte, this.dictionaryWriter, this.longDictionaryWriter, this.doubleDictionaryWriter, this.arrayDictionaryWriter, encodedValueSerializer, bitmapIndexWriter, this.arrayElementDictionaryWriter, arrayElementIndexWriter, this.dictionaryIdLookup, this.writeDictionary);
        }
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.closeForWrite();
        return this.internalSerializer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.closeForWrite();
        this.internalSerializer.writeTo(channel, smoosher);
    }

    public static class InternalSerializer
    implements Serializer {
        private final String columnName;
        private final ByteBuffer columnNameBytes;
        private final Byte variantTypeSetByte;
        private final DictionaryWriter<String> dictionaryWriter;
        private final FixedIndexedWriter<Long> longDictionaryWriter;
        private final FixedIndexedWriter<Double> doubleDictionaryWriter;
        private final FrontCodedIntArrayIndexedWriter arrayDictionaryWriter;
        private final SingleValueColumnarIntsSerializer encodedValueSerializer;
        private final GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter;
        private final FixedIndexedIntWriter arrayElementDictionaryWriter;
        private final GenericIndexedWriter<ImmutableBitmap> arrayElementIndexWriter;
        private final boolean writeDictionary;
        private final DictionaryIdLookup dictionaryIdLookup;

        public InternalSerializer(String columnName, Byte variantTypeSetByte, DictionaryWriter<String> dictionaryWriter, FixedIndexedWriter<Long> longDictionaryWriter, FixedIndexedWriter<Double> doubleDictionaryWriter, FrontCodedIntArrayIndexedWriter arrayDictionaryWriter, SingleValueColumnarIntsSerializer encodedValueSerializer, GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter, FixedIndexedIntWriter arrayElementDictionaryWriter, GenericIndexedWriter<ImmutableBitmap> arrayElementIndexWriter, DictionaryIdLookup dictionaryIdLookup, boolean writeDictionary) {
            this.columnName = columnName;
            this.columnNameBytes = ColumnSerializerUtils.stringToUtf8InVSizeByteBuffer(columnName);
            this.variantTypeSetByte = variantTypeSetByte;
            this.dictionaryWriter = dictionaryWriter;
            this.longDictionaryWriter = longDictionaryWriter;
            this.doubleDictionaryWriter = doubleDictionaryWriter;
            this.arrayDictionaryWriter = arrayDictionaryWriter;
            this.encodedValueSerializer = encodedValueSerializer;
            this.bitmapIndexWriter = bitmapIndexWriter;
            this.arrayElementDictionaryWriter = arrayElementDictionaryWriter;
            this.arrayElementIndexWriter = arrayElementIndexWriter;
            this.writeDictionary = writeDictionary;
            this.dictionaryIdLookup = dictionaryIdLookup;
            if (writeDictionary) {
                boolean[] dictionariesSorted;
                for (boolean sorted : dictionariesSorted = new boolean[]{dictionaryWriter.isSorted(), longDictionaryWriter.isSorted(), doubleDictionaryWriter.isSorted(), arrayDictionaryWriter.isSorted()}) {
                    if (sorted) continue;
                    throw DruidException.defensive("Dictionary is not sorted? [%s]  Should always be sorted", Arrays.toString(dictionariesSorted));
                }
            }
        }

        @Override
        public long getSerializedSize() {
            long size = 1 + this.columnNameBytes.capacity();
            if (this.variantTypeSetByte != null) {
                ++size;
            }
            return size;
        }

        @Override
        public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
            NestedCommonFormatColumnSerializer.writeV0Header(channel, this.columnNameBytes);
            if (this.variantTypeSetByte != null) {
                channel.write(ByteBuffer.wrap(new byte[]{this.variantTypeSetByte}));
            }
            if (this.writeDictionary) {
                if (this.dictionaryIdLookup.getStringBufferMapper() != null) {
                    NestedCommonFormatColumnSerializer.copyFromTempSmoosh(smoosher, this.dictionaryIdLookup.getStringBufferMapper());
                } else {
                    ColumnSerializerUtils.writeInternal(smoosher, this.dictionaryWriter, this.columnName, "__stringDictionary");
                }
                if (this.dictionaryIdLookup.getLongBufferMapper() != null) {
                    NestedCommonFormatColumnSerializer.copyFromTempSmoosh(smoosher, this.dictionaryIdLookup.getLongBufferMapper());
                } else {
                    ColumnSerializerUtils.writeInternal(smoosher, this.longDictionaryWriter, this.columnName, "__longDictionary");
                }
                if (this.dictionaryIdLookup.getDoubleBufferMapper() != null) {
                    NestedCommonFormatColumnSerializer.copyFromTempSmoosh(smoosher, this.dictionaryIdLookup.getDoubleBufferMapper());
                } else {
                    ColumnSerializerUtils.writeInternal(smoosher, this.doubleDictionaryWriter, this.columnName, "__doubleDictionary");
                }
                if (this.dictionaryIdLookup.getArrayBufferMapper() != null) {
                    NestedCommonFormatColumnSerializer.copyFromTempSmoosh(smoosher, this.dictionaryIdLookup.getArrayBufferMapper());
                } else {
                    ColumnSerializerUtils.writeInternal(smoosher, this.arrayDictionaryWriter, this.columnName, "__arrayDictionary");
                }
                ColumnSerializerUtils.writeInternal(smoosher, this.arrayElementDictionaryWriter, this.columnName, "__arrayElementDictionary");
            }
            ColumnSerializerUtils.writeInternal(smoosher, this.encodedValueSerializer, this.columnName, "__encodedColumn");
            ColumnSerializerUtils.writeInternal(smoosher, this.bitmapIndexWriter, this.columnName, "__valueIndexes");
            ColumnSerializerUtils.writeInternal(smoosher, this.arrayElementIndexWriter, this.columnName, "__arrayElementIndexes");
            log.info("Column [%s] serialized successfully.", this.columnName);
        }
    }
}

