/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;

public class IntIndexView {
    private final ByteBuffer byteBuffer;
    private final int numberOfEntries;

    public IntIndexView(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.numberOfEntries = byteBuffer.remaining() / 4;
    }

    public EntrySpan getEntrySpan(int entryNumber) {
        Preconditions.checkArgument((entryNumber < this.numberOfEntries ? 1 : 0) != 0, (String)"invalid entry number %s [%s]", (int)entryNumber, (int)this.numberOfEntries);
        int start = this.byteBuffer.getInt(this.byteBuffer.position() + entryNumber * 4);
        int nextStart = this.byteBuffer.getInt(this.byteBuffer.position() + (entryNumber + 1) * 4);
        return new EntrySpan(start, nextStart - start);
    }

    public static class EntrySpan {
        private final int start;
        private final int size;

        public EntrySpan(int start, int size) {
            this.start = start;
            this.size = size;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }
    }
}

