/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.druid.segment.serde.cell.StorableBuffer;

public interface StagedSerde<T> {
    public static StagedSerde<byte[]> forBytes() {
        return new StagedSerde<byte[]>(){

            @Override
            public byte[] serialize(byte[] value) {
                return value;
            }

            @Override
            public byte[] deserialize(byte[] bytes) {
                return bytes;
            }

            @Override
            public StorableBuffer serializeDelayed(@Nullable byte[] value) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public byte[] deserialize(ByteBuffer byteBuffer) {
                byte[] retVal = new byte[byteBuffer.remaining()];
                int position = byteBuffer.position();
                byteBuffer.get(retVal);
                byteBuffer.position(position);
                return retVal;
            }
        };
    }

    public StorableBuffer serializeDelayed(@Nullable T var1);

    default public byte[] serialize(T value) {
        StorableBuffer storableBuffer = this.serializeDelayed(value);
        ByteBuffer byteBuffer = ByteBuffer.allocate(storableBuffer.getSerializedSize()).order(ByteOrder.nativeOrder());
        storableBuffer.store(byteBuffer);
        return byteBuffer.array();
    }

    @Nullable
    public T deserialize(ByteBuffer var1);

    default public T deserialize(byte[] bytes) {
        return this.deserialize(ByteBuffer.wrap(bytes).order(ByteOrder.nativeOrder()));
    }
}

