/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public final class SegmentId
implements Comparable<SegmentId> {
    private static final Interner<String> STRING_INTERNER = Interners.newWeakInterner();
    private static final Interner<Interval> INTERVAL_INTERNER = Interners.newWeakInterner();
    private static final char DELIMITER = '_';
    private static final Splitter DELIMITER_SPLITTER = Splitter.on((char)'_');
    private static final Joiner DELIMITER_JOINER = Joiner.on((char)'_');
    private static final int DATE_TIME_SIZE_UPPER_LIMIT = "yyyy-MM-ddTHH:mm:ss.SSS+00:00".length();
    private final String dataSource;
    private final Interval interval;
    private final String version;
    private final int partitionNum;
    private final int hashCode;

    public static SegmentId of(String dataSource, Interval interval, String version, int partitionNum) {
        return new SegmentId(dataSource, interval, version, partitionNum);
    }

    public static SegmentId of(String dataSource, Interval interval, String version, @Nullable ShardSpec shardSpec) {
        return SegmentId.of(dataSource, interval, version, shardSpec != null ? shardSpec.getPartitionNum() : 0);
    }

    @Nullable
    public static SegmentId tryParse(String dataSource, String segmentId) {
        List<SegmentId> possibleParsings = SegmentId.iteratePossibleParsingsWithDataSource(dataSource, segmentId);
        return possibleParsings.isEmpty() ? null : possibleParsings.get(0);
    }

    public static Iterable<SegmentId> iterateAllPossibleParsings(String segmentId) {
        List splits = DELIMITER_SPLITTER.splitToList((CharSequence)segmentId);
        String probableDataSource = SegmentId.tryExtractMostProbableDataSource(segmentId);
        if (probableDataSource != null) {
            List<SegmentId> probableParsings = SegmentId.iteratePossibleParsingsWithDataSource(probableDataSource, segmentId);
            Iterable otherPossibleParsings = () -> IntStream.range(1, splits.size() - 3).mapToObj(dataSourceDelimiterOrder -> DELIMITER_JOINER.join(splits.subList(0, dataSourceDelimiterOrder))).filter(dataSource -> dataSource.length() != probableDataSource.length()).flatMap(dataSource -> SegmentId.iteratePossibleParsingsWithDataSource(dataSource, segmentId).stream()).iterator();
            return Iterables.concat(probableParsings, otherPossibleParsings);
        }
        return () -> IntStream.range(1, splits.size() - 3).mapToObj(dataSourceDelimiterOrder -> {
            String dataSource = DELIMITER_JOINER.join(splits.subList(0, dataSourceDelimiterOrder));
            return SegmentId.iteratePossibleParsingsWithDataSource(dataSource, segmentId);
        }).flatMap(Collection::stream).iterator();
    }

    public static List<SegmentId> iteratePossibleParsingsWithDataSource(String dataSource, String segmentId) {
        String trail;
        DateTime end;
        DateTime start;
        if (!segmentId.startsWith(dataSource) || segmentId.charAt(dataSource.length()) != '_') {
            return Collections.emptyList();
        }
        String remaining = segmentId.substring(dataSource.length() + 1);
        List splits = DELIMITER_SPLITTER.splitToList((CharSequence)remaining);
        if (splits.size() < 3) {
            return Collections.emptyList();
        }
        try {
            start = DateTimes.ISO_DATE_TIME.parse((String)splits.get(0));
            end = DateTimes.ISO_DATE_TIME.parse((String)splits.get(1));
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
        if (start.compareTo((ReadableInstant)end) >= 0) {
            return Collections.emptyList();
        }
        ArrayList<SegmentId> possibleParsings = new ArrayList<SegmentId>(2);
        Object version = DELIMITER_JOINER.join(splits.subList(2, Math.max(splits.size() - 1, 3)));
        String string = trail = splits.size() > 3 ? (String)splits.get(splits.size() - 1) : null;
        if (trail != null) {
            Integer possiblePartitionNum = Ints.tryParse(trail);
            if (possiblePartitionNum != null && possiblePartitionNum > 0) {
                possibleParsings.add(SegmentId.of(dataSource, new Interval((ReadableInstant)start, (ReadableInstant)end), (String)version, possiblePartitionNum));
            }
            version = (String)version + "_" + trail;
        }
        possibleParsings.add(SegmentId.of(dataSource, new Interval((ReadableInstant)start, (ReadableInstant)end), (String)version, 0));
        return possibleParsings;
    }

    @Nullable
    @VisibleForTesting
    static String tryExtractMostProbableDataSource(String segmentId) {
        int dataSourceEnd;
        Matcher dateTimeMatcher = DateTimes.COMMON_DATE_TIME_PATTERN.matcher(segmentId);
        do {
            if (dateTimeMatcher.find()) continue;
            return null;
        } while (segmentId.charAt(dataSourceEnd = dateTimeMatcher.start() - 1) != '_');
        return segmentId.substring(0, dataSourceEnd);
    }

    public static SegmentId merged(String dataSource, Interval interval, int partitionNum) {
        return SegmentId.of(dataSource, interval, "merged", partitionNum);
    }

    public static SegmentId dummy(String dataSource) {
        return SegmentId.of(dataSource, Intervals.ETERNITY, "dummy_version", 0);
    }

    public static SegmentId dummy(String dataSource, int partitionNum) {
        return SegmentId.of(dataSource, Intervals.ETERNITY, "dummy_version", partitionNum);
    }

    private SegmentId(String dataSource, Interval interval, String version, int partitionNum) {
        this.dataSource = (String)STRING_INTERNER.intern((Object)Objects.requireNonNull(dataSource));
        this.interval = (Interval)INTERVAL_INTERNER.intern((Object)Objects.requireNonNull(interval));
        this.version = Objects.requireNonNull(version);
        this.partitionNum = partitionNum;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int hashCode = this.partitionNum;
        hashCode = hashCode * 1000003 + this.version.hashCode();
        hashCode = hashCode * 1000003 + this.dataSource.hashCode();
        hashCode = hashCode * 1000003 + this.interval.hashCode();
        return hashCode;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public DateTime getIntervalStart() {
        return new DateTime(this.interval.getStartMillis(), this.interval.getChronology());
    }

    public DateTime getIntervalEnd() {
        return new DateTime(this.interval.getEndMillis(), this.interval.getChronology());
    }

    public Interval getInterval() {
        return this.interval;
    }

    public String getVersion() {
        return this.version;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public SegmentId withInterval(Interval newInterval) {
        return SegmentId.of(this.dataSource, newInterval, this.version, this.partitionNum);
    }

    public SegmentDescriptor toDescriptor() {
        return new SegmentDescriptor(Intervals.utc(this.interval.getStartMillis(), this.interval.getEndMillis()), this.version, this.partitionNum);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SegmentId)) {
            return false;
        }
        SegmentId that = (SegmentId)o;
        return this.hashCode == that.hashCode && this.dataSource.equals(that.dataSource) && this.interval.equals((Object)that.interval) && this.version.equals(that.version);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(SegmentId o) {
        int result = this.dataSource.compareTo(o.dataSource);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.interval.getStartMillis(), o.interval.getStartMillis());
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.interval.getEndMillis(), o.interval.getEndMillis());
        if (result != 0) {
            return result;
        }
        result = this.version.compareTo(o.version);
        if (result != 0) {
            return result;
        }
        return Integer.compare(this.partitionNum, o.partitionNum);
    }

    @JsonValue
    public String toString() {
        StringBuilder sb = new StringBuilder(this.safeUpperLimitOfStringSize());
        sb.append(this.dataSource).append('_').append(this.getIntervalStart()).append('_').append(this.getIntervalEnd()).append('_').append(this.version);
        if (this.partitionNum != 0) {
            sb.append('_').append(this.partitionNum);
        }
        return sb.toString();
    }

    public int safeUpperLimitOfStringSize() {
        int delimiters = 4;
        int partitionNumSizeUpperLimit = 3;
        return this.dataSource.length() + this.version.length() + DATE_TIME_SIZE_UPPER_LIMIT * 2 + delimiters + partitionNumSizeUpperLimit;
    }
}

