/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.overlord.common;

import java.util.Objects;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.k8s.overlord.common.KubernetesOverlordUtils;

public class K8sTaskId {
    private final String k8sJobName;
    private final String originalTaskId;

    public K8sTaskId(String k8sTaskPodNamePrefix, Task task) {
        this(k8sTaskPodNamePrefix, task.getId());
    }

    public K8sTaskId(String k8sTaskPodNamePrefix, String taskId) {
        this.originalTaskId = taskId;
        this.k8sJobName = KubernetesOverlordUtils.convertTaskIdToJobName(k8sTaskPodNamePrefix, taskId);
    }

    public String getK8sJobName() {
        return this.k8sJobName;
    }

    public String getOriginalTaskId() {
        return this.originalTaskId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        K8sTaskId k8sTaskId1 = (K8sTaskId)o;
        return this.k8sJobName.equals(k8sTaskId1.k8sJobName) && this.originalTaskId.equals(k8sTaskId1.originalTaskId);
    }

    public int hashCode() {
        return Objects.hash(this.k8sJobName, this.originalTaskId);
    }

    public String toString() {
        return "[ " + this.originalTaskId + ", " + this.k8sJobName + "]";
    }
}

