/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.guice;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.msq.dart.Dart;
import org.apache.druid.msq.dart.DartResourcePermissionMapper;
import org.apache.druid.msq.dart.controller.ControllerMessageListener;
import org.apache.druid.msq.dart.controller.DartControllerContextFactory;
import org.apache.druid.msq.dart.controller.DartControllerContextFactoryImpl;
import org.apache.druid.msq.dart.controller.DartControllerRegistry;
import org.apache.druid.msq.dart.controller.DartMessageRelayFactoryImpl;
import org.apache.druid.msq.dart.controller.DartMessageRelays;
import org.apache.druid.msq.dart.controller.http.DartQueryInfo;
import org.apache.druid.msq.dart.controller.sql.DartSqlClientFactory;
import org.apache.druid.msq.dart.controller.sql.DartSqlClientFactoryImpl;
import org.apache.druid.msq.dart.controller.sql.DartSqlClients;
import org.apache.druid.msq.dart.controller.sql.DartSqlEngine;
import org.apache.druid.msq.dart.guice.DartControllerConfig;
import org.apache.druid.msq.dart.guice.DartModules;
import org.apache.druid.msq.rpc.ResourcePermissionMapper;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.run.SqlEngine;

@LoadScope(roles={"broker"})
public class DartControllerModule
implements DruidModule {
    @Inject
    private Properties properties;

    public void configure(Binder binder) {
        if (DartModules.isDartEnabled(this.properties)) {
            binder.install((Module)new ActualModule());
        }
    }

    public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule("DartModule").registerSubtypes(new NamedType[]{new NamedType(DartQueryInfo.class, "msq-dart")}));
    }

    public static class ActualModule
    implements Module {
        public void configure(Binder binder) {
            JsonConfigProvider.bind((Binder)binder, (String)"druid.msq.dart.controller", DartControllerConfig.class);
            JsonConfigProvider.bind((Binder)binder, (String)"druid.msq.dart.query", DefaultQueryConfig.class, Dart.class);
            LifecycleModule.register((Binder)binder, DartSqlClients.class);
            LifecycleModule.register((Binder)binder, DartMessageRelays.class);
            binder.bind(ControllerMessageListener.class).in(LazySingleton.class);
            binder.bind(DartControllerRegistry.class).in(LazySingleton.class);
            binder.bind(DartMessageRelayFactoryImpl.class).in(LazySingleton.class);
            binder.bind(DartControllerContextFactory.class).to(DartControllerContextFactoryImpl.class).in(LazySingleton.class);
            binder.bind(DartSqlClientFactory.class).to(DartSqlClientFactoryImpl.class).in(LazySingleton.class);
            binder.bind(ResourcePermissionMapper.class).annotatedWith(Dart.class).to(DartResourcePermissionMapper.class);
            Multibinder.newSetBinder((Binder)binder, SqlEngine.class).addBinding().to(DartSqlEngine.class).in(LazySingleton.class);
        }

        @Provides
        @Dart
        @LazySingleton
        public SqlStatementFactory makeSqlStatementFactory(DartSqlEngine engine, SqlToolbox toolbox) {
            return new SqlStatementFactory(toolbox.withEngine((SqlEngine)engine));
        }

        @Provides
        @ManageLifecycle
        public DartMessageRelays makeMessageRelays(DruidNodeDiscoveryProvider discoveryProvider, DartMessageRelayFactoryImpl messageRelayFactory) {
            return new DartMessageRelays(discoveryProvider, messageRelayFactory);
        }
    }
}

