/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.guice;

import com.google.inject.Binder;
import com.google.inject.Provides;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.MemoryIntrospectorImpl;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.guice.PeonMemoryManagementModule;
import org.apache.druid.msq.guice.TaskMemoryManagementConfig;
import org.apache.druid.msq.indexing.IndexerProcessingBuffersProvider;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.utils.RuntimeInfo;

@LoadScope(roles={"indexer"})
public class IndexerMemoryManagementModule
implements DruidModule {
    private static final double MSQ_MEMORY_FRACTION = 0.6;
    private static final double PROCESSING_MEMORY_FRACTION = 0.15;

    public void configure(Binder binder) {
        TaskMemoryManagementConfig.bind(binder);
    }

    @Provides
    @ManageLifecycle
    public MemoryIntrospector createMemoryIntrospector(RuntimeInfo runtimeInfo, LookupExtractorFactoryContainerProvider lookupProvider, TaskMemoryManagementConfig taskMemoryManagementConfig, DruidProcessingConfig processingConfig, WorkerConfig workerConfig) {
        return new MemoryIntrospectorImpl(runtimeInfo.getMaxHeapSizeBytes(), 0.6, workerConfig.getCapacity(), PeonMemoryManagementModule.getNumThreads(taskMemoryManagementConfig, processingConfig), lookupProvider);
    }

    @Provides
    @LazySingleton
    public ProcessingBuffersProvider createProcessingBuffersProvider(MemoryIntrospector memoryIntrospector, WorkerConfig workerConfig, RuntimeInfo runtimeInfo) {
        return new IndexerProcessingBuffersProvider((long)((double)runtimeInfo.getMaxHeapSizeBytes() * 0.15), workerConfig.getCapacity(), memoryIntrospector.numProcessingThreads());
    }
}

