/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

public enum ControllerStagePhase {
    NEW{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return false;
        }
    }
    ,
    READING_INPUT{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == RETRYING || priorPhase == NEW;
        }
    }
    ,
    MERGING_STATISTICS{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == READING_INPUT;
        }
    }
    ,
    POST_READING{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == READING_INPUT || priorPhase == MERGING_STATISTICS;
        }
    }
    ,
    RESULTS_READY{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == READING_INPUT || priorPhase == POST_READING;
        }
    }
    ,
    FINISHED{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return !priorPhase.isTerminal();
        }
    }
    ,
    FAILED{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return true;
        }
    }
    ,
    RETRYING{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == READING_INPUT || priorPhase == POST_READING || priorPhase == MERGING_STATISTICS || priorPhase == RETRYING;
        }
    };


    public abstract boolean canTransitionFrom(ControllerStagePhase var1);

    public boolean isRunning() {
        return this == READING_INPUT || this == MERGING_STATISTICS || this == POST_READING || this == RESULTS_READY || this == RETRYING;
    }

    public boolean isDoneReadingInput() {
        return this == POST_READING || this == RESULTS_READY || this == FINISHED;
    }

    public boolean isSuccess() {
        return this == RESULTS_READY || this == FINISHED;
    }

    public boolean isTerminal() {
        return this == FINISHED || this == FAILED;
    }
}

