/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

public enum ControllerWorkerStagePhase {
    NEW{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return false;
        }
    }
    ,
    READING_INPUT{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return priorPhase == NEW;
        }
    }
    ,
    PRESHUFFLE_WAITING_FOR_ALL_KEY_STATS_TO_BE_FETCHED{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return priorPhase == READING_INPUT;
        }
    }
    ,
    PRESHUFFLE_FETCHING_ALL_KEY_STATS{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return priorPhase == PRESHUFFLE_WAITING_FOR_ALL_KEY_STATS_TO_BE_FETCHED;
        }
    }
    ,
    PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return priorPhase == PRESHUFFLE_FETCHING_ALL_KEY_STATS;
        }
    }
    ,
    PRESHUFFLE_WRITING_OUTPUT{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return priorPhase == READING_INPUT || priorPhase == PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES;
        }
    }
    ,
    RESULTS_READY{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return priorPhase == READING_INPUT || priorPhase == PRESHUFFLE_WRITING_OUTPUT;
        }
    }
    ,
    FINISHED{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return priorPhase == RESULTS_READY;
        }
    }
    ,
    FAILED{

        @Override
        public boolean canTransitionFrom(ControllerWorkerStagePhase priorPhase) {
            return true;
        }
    };


    public abstract boolean canTransitionFrom(ControllerWorkerStagePhase var1);
}

