/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.scan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.querykit.BaseLeafStageProcessor;
import org.apache.druid.msq.querykit.scan.ScanQueryFrameProcessor;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.filtration.Filtration;

@JsonTypeName(value="scan")
public class ScanQueryStageProcessor
extends BaseLeafStageProcessor {
    private static final String IRRELEVANT = "irrelevant";
    private final ScanQuery query;
    @Nullable
    private final AtomicLong runningCountForLimit;

    @JsonCreator
    public ScanQueryStageProcessor(@JsonProperty(value="query") ScanQuery query) {
        super((Query<?>)query);
        this.query = (ScanQuery)Preconditions.checkNotNull((Object)query, (Object)"query");
        this.runningCountForLimit = query.isLimited() && query.getOrderBys().isEmpty() ? new AtomicLong() : null;
    }

    public static ScanQueryStageProcessor makeScanStageProcessor(VirtualColumns virtualColumns, RowSignature signature, DimFilter dimFilter) {
        Filtration filtration = Filtration.create((DimFilter)dimFilter).optimizeFilterOnly(signature);
        DimFilter newFilter = filtration.getDimFilter();
        ScanQuery scanQuery = Druids.newScanQueryBuilder().dataSource(IRRELEVANT).intervals(QuerySegmentSpec.ETERNITY).filters(newFilter).virtualColumns(virtualColumns).columns(signature.getColumnNames()).columnTypes(signature.getColumnTypes()).build();
        return new ScanQueryStageProcessor(scanQuery);
    }

    @JsonProperty
    public ScanQuery getQuery() {
        return this.query;
    }

    @Override
    protected FrameProcessor<Object> makeProcessor(ReadableInput baseInput, SegmentMapFunction segmentMapFn, ResourceHolder<WritableFrameChannel> outputChannelHolder, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder, FrameContext frameContext) {
        return new ScanQueryFrameProcessor(this.query, this.runningCountForLimit, frameContext.jsonMapper(), baseInput, segmentMapFn, outputChannelHolder, frameWriterFactoryHolder);
    }

    @Override
    public boolean usesProcessingBuffers() {
        return false;
    }
}

