/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.statistics.KeyCollectorSnapshot;
import org.apache.druid.msq.statistics.serde.DelegateOrMinSerializer;
import org.apache.druid.msq.statistics.serde.KeyCollectorSnapshotSerializer;

@JsonTypeName(value="delegate")
public class DelegateOrMinKeyCollectorSnapshot<T extends KeyCollectorSnapshot>
implements KeyCollectorSnapshot {
    static final String FIELD_SNAPSHOT = "snapshot";
    static final String FIELD_MIN_KEY = "minKey";
    static final String TYPE = "delegate";
    private final T snapshot;
    private final RowKey minKey;

    @JsonCreator
    public DelegateOrMinKeyCollectorSnapshot(@JsonProperty(value="snapshot") T snapshot, @JsonProperty(value="minKey") RowKey minKey) {
        this.snapshot = snapshot;
        this.minKey = minKey;
        if (snapshot != null && minKey != null) {
            throw new ISE("Cannot have both '%s' and '%s'", new Object[]{FIELD_SNAPSHOT, FIELD_MIN_KEY});
        }
    }

    @Nullable
    @JsonProperty(value="snapshot")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public T getSnapshot() {
        return this.snapshot;
    }

    @Nullable
    @JsonProperty(value="minKey")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RowKey getMinKey() {
        return this.minKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegateOrMinKeyCollectorSnapshot that = (DelegateOrMinKeyCollectorSnapshot)o;
        return Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.minKey, that.minKey);
    }

    public int hashCode() {
        return Objects.hash(this.snapshot, this.minKey);
    }

    @Override
    public KeyCollectorSnapshotSerializer getSerializer() {
        return new DelegateOrMinSerializer();
    }

    public String toString() {
        return "DelegateOrMinKeyCollectorSnapshot{snapshot=" + String.valueOf(this.snapshot) + ", minKey=" + String.valueOf(this.minKey) + "}";
    }
}

