/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityBuilder;
import io.fabric8.kubernetes.api.model.QuantityFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmptyDirVolumeSourceFluent<A extends EmptyDirVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private String medium;
    private QuantityBuilder sizeLimit;
    private Map<String, Object> additionalProperties;

    public EmptyDirVolumeSourceFluent() {
    }

    public EmptyDirVolumeSourceFluent(EmptyDirVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(EmptyDirVolumeSource instance) {
        EmptyDirVolumeSource emptyDirVolumeSource = instance = instance != null ? instance : new EmptyDirVolumeSource();
        if (instance != null) {
            this.withMedium(instance.getMedium());
            this.withSizeLimit(instance.getSizeLimit());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getMedium() {
        return this.medium;
    }

    public A withMedium(String medium) {
        this.medium = medium;
        return (A)((Object)this);
    }

    public boolean hasMedium() {
        return this.medium != null;
    }

    public Quantity buildSizeLimit() {
        return this.sizeLimit != null ? this.sizeLimit.build() : null;
    }

    public A withSizeLimit(Quantity sizeLimit) {
        this._visitables.remove((Object)"sizeLimit");
        if (sizeLimit != null) {
            this.sizeLimit = new QuantityBuilder(sizeLimit);
            this._visitables.get((Object)"sizeLimit").add(this.sizeLimit);
        } else {
            this.sizeLimit = null;
            this._visitables.get((Object)"sizeLimit").remove((Object)this.sizeLimit);
        }
        return (A)((Object)this);
    }

    public boolean hasSizeLimit() {
        return this.sizeLimit != null;
    }

    public A withNewSizeLimit(String amount, String format) {
        return this.withSizeLimit(new Quantity(amount, format));
    }

    public A withNewSizeLimit(String amount) {
        return this.withSizeLimit(new Quantity(amount));
    }

    public SizeLimitNested<A> withNewSizeLimit() {
        return new SizeLimitNested(null);
    }

    public SizeLimitNested<A> withNewSizeLimitLike(Quantity item) {
        return new SizeLimitNested(item);
    }

    public SizeLimitNested<A> editSizeLimit() {
        return this.withNewSizeLimitLike(Optional.ofNullable(this.buildSizeLimit()).orElse(null));
    }

    public SizeLimitNested<A> editOrNewSizeLimit() {
        return this.withNewSizeLimitLike(Optional.ofNullable(this.buildSizeLimit()).orElse(new QuantityBuilder().build()));
    }

    public SizeLimitNested<A> editOrNewSizeLimitLike(Quantity item) {
        return this.withNewSizeLimitLike(Optional.ofNullable(this.buildSizeLimit()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmptyDirVolumeSourceFluent that = (EmptyDirVolumeSourceFluent)((Object)o);
        if (!Objects.equals(this.medium, that.medium)) {
            return false;
        }
        if (!Objects.equals((Object)this.sizeLimit, (Object)that.sizeLimit)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.medium, this.sizeLimit, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.medium != null) {
            sb.append("medium:");
            sb.append(this.medium + ",");
        }
        if (this.sizeLimit != null) {
            sb.append("sizeLimit:");
            sb.append(String.valueOf((Object)this.sizeLimit) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SizeLimitNested<N>
    extends QuantityFluent<SizeLimitNested<N>>
    implements Nested<N> {
        QuantityBuilder builder;

        SizeLimitNested(Quantity item) {
            this.builder = new QuantityBuilder(this, item);
        }

        public N and() {
            return (N)EmptyDirVolumeSourceFluent.this.withSizeLimit(this.builder.build());
        }

        public N endSizeLimit() {
            return this.and();
        }
    }
}

