/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.google.GoogleDataSegmentPuller;

@JsonTypeName(value="google")
public class GoogleLoadSpec
implements LoadSpec {
    @JsonProperty
    private final String bucket;
    @JsonProperty
    private final String path;
    private final GoogleDataSegmentPuller puller;

    @JsonCreator
    public GoogleLoadSpec(@JsonProperty(value="bucket") String bucket, @JsonProperty(value="path") String path, @JacksonInject GoogleDataSegmentPuller puller) {
        Preconditions.checkNotNull((Object)bucket);
        Preconditions.checkNotNull((Object)path);
        this.bucket = bucket;
        this.path = path;
        this.puller = puller;
    }

    public LoadSpec.LoadSpecResult loadSegment(File file) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(this.bucket, this.path, file).size());
    }
}

