/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class Columns {
    public static final String TIME_COLUMN = "__time";
    public static final String STRING = ValueType.STRING.name();
    public static final String LONG = ValueType.LONG.name();
    public static final String FLOAT = ValueType.FLOAT.name();
    public static final String DOUBLE = ValueType.DOUBLE.name();
    public static final String SQL_VARCHAR = "VARCHAR";
    public static final String SQL_BIGINT = "BIGINT";
    public static final String SQL_FLOAT = "FLOAT";
    public static final String SQL_DOUBLE = "DOUBLE";
    public static final String SQL_VARCHAR_ARRAY = "VARCHAR ARRAY";
    public static final String SQL_BIGINT_ARRAY = "BIGINT ARRAY";
    public static final String SQL_FLOAT_ARRAY = "FLOAT ARRAY";
    public static final String SQL_DOUBLE_ARRAY = "DOUBLE ARRAY";
    public static final String SQL_TIMESTAMP = "TIMESTAMP";
    public static final Map<String, ColumnType> SQL_TO_DRUID_TYPES = new ImmutableMap.Builder().put((Object)"TIMESTAMP", (Object)ColumnType.LONG).put((Object)"BIGINT", (Object)ColumnType.LONG).put((Object)"FLOAT", (Object)ColumnType.FLOAT).put((Object)"DOUBLE", (Object)ColumnType.DOUBLE).put((Object)"VARCHAR", (Object)ColumnType.STRING).put((Object)"VARCHAR ARRAY", (Object)ColumnType.STRING_ARRAY).put((Object)"BIGINT ARRAY", (Object)ColumnType.LONG_ARRAY).put((Object)"FLOAT ARRAY", (Object)ColumnType.FLOAT_ARRAY).put((Object)"DOUBLE ARRAY", (Object)ColumnType.DOUBLE_ARRAY).build();
    public static final Map<ColumnType, String> DRUID_TO_SQL_TYPES = new ImmutableMap.Builder().put((Object)ColumnType.LONG, (Object)"BIGINT").put((Object)ColumnType.FLOAT, (Object)FLOAT).put((Object)ColumnType.DOUBLE, (Object)DOUBLE).put((Object)ColumnType.STRING, (Object)"VARCHAR").put((Object)ColumnType.STRING_ARRAY, (Object)"VARCHAR ARRAY").put((Object)ColumnType.LONG_ARRAY, (Object)"BIGINT ARRAY").put((Object)ColumnType.FLOAT_ARRAY, (Object)"FLOAT ARRAY").put((Object)ColumnType.DOUBLE_ARRAY, (Object)"DOUBLE ARRAY").build();

    private Columns() {
    }

    public static ColumnType druidType(ColumnSpec spec) {
        if (Columns.isTimeColumn(spec.name())) {
            return ColumnType.LONG;
        }
        String dataType = spec.dataType();
        if (dataType == null) {
            return null;
        }
        ColumnType druidType = SQL_TO_DRUID_TYPES.get(StringUtils.toUpperCase((String)dataType));
        if (druidType != null) {
            return druidType;
        }
        return ColumnType.fromString((String)dataType);
    }

    public static String sqlType(ColumnSpec spec) {
        if (Columns.isTimeColumn(spec.name())) {
            return SQL_TIMESTAMP;
        }
        ColumnType druidType = Columns.druidType(spec);
        if (druidType == null) {
            return null;
        }
        String sqlType = DRUID_TO_SQL_TYPES.get(druidType);
        return sqlType == null ? druidType.asTypeString() : sqlType;
    }

    public static boolean isTimeColumn(String name) {
        return TIME_COLUMN.equals(name);
    }

    public static RowSignature convertSignature(List<ColumnSpec> columns) {
        RowSignature.Builder builder = RowSignature.builder();
        for (ColumnSpec col : columns) {
            ColumnType druidType = Columns.druidType(col);
            if (druidType == null) {
                druidType = ColumnType.STRING;
            }
            builder.add(col.name(), druidType);
        }
        return builder.build();
    }

    public static String sqlType(ColumnType druidType) {
        return DRUID_TO_SQL_TYPES.get(druidType);
    }
}

