/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.druid.java.util.emitter.service.AlertBuilder;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;

public class DruidConnectionStateListener
extends AbstractMonitor
implements ConnectionStateListener {
    private static final String METRIC_IS_CONNECTED = "zk/connected";
    private static final String METRIC_RECONNECT_TIME = "zk/reconnect/time";
    private static final int NIL = -1;
    private final ServiceEmitter emitter;
    @GuardedBy(value="this")
    private ConnectionState currentState;
    @GuardedBy(value="this")
    private long lastDisconnectTime = -1L;

    public DruidConnectionStateListener(ServiceEmitter emitter) {
        this.emitter = emitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(CuratorFramework curatorFramework, ConnectionState newState) {
        if (newState.isConnected()) {
            long disconnectDuration;
            DruidConnectionStateListener druidConnectionStateListener = this;
            synchronized (druidConnectionStateListener) {
                disconnectDuration = this.lastDisconnectTime != -1L ? Math.max(0L, System.currentTimeMillis() - this.lastDisconnectTime) : -1L;
                this.currentState = newState;
                this.lastDisconnectTime = -1L;
            }
            if (disconnectDuration != -1L) {
                this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric(METRIC_RECONNECT_TIME, (Number)disconnectDuration));
            }
        } else {
            DruidConnectionStateListener druidConnectionStateListener = this;
            synchronized (druidConnectionStateListener) {
                this.currentState = newState;
                this.lastDisconnectTime = Math.max(this.lastDisconnectTime, System.currentTimeMillis());
            }
            this.emitter.emit((ServiceEventBuilder)AlertBuilder.create((String)"ZooKeeper connection[%s]", (Object[])new Object[]{newState}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        DruidConnectionStateListener druidConnectionStateListener = this;
        synchronized (druidConnectionStateListener) {
            return this.currentState != null && this.currentState.isConnected();
        }
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric(METRIC_IS_CONNECTED, (Number)(this.isConnected() ? 1 : 0)));
        return true;
    }
}

