/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.inject.Inject;
import java.util.Optional;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.lookup.LookupJoinable;

public class LookupJoinableFactory
implements JoinableFactory {
    private final LookupExtractorFactoryContainerProvider lookupProvider;

    @Inject
    public LookupJoinableFactory(LookupExtractorFactoryContainerProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    public boolean isDirectlyJoinable(DataSource dataSource) {
        return dataSource instanceof LookupDataSource;
    }

    public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
        LookupDataSource lookupDataSource = (LookupDataSource)dataSource;
        if (condition.canHashJoin()) {
            String lookupName = lookupDataSource.getLookupName();
            return this.lookupProvider.get(lookupName).map(c -> LookupJoinable.wrap((LookupExtractor)((LookupExtractor)c.getLookupExtractorFactory().get())));
        }
        return Optional.empty();
    }
}

