/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;

public class CentralizedDatasourceSchemaConfig {
    public static final String PROPERTY_PREFIX = "druid.centralizedDatasourceSchema";
    private static final CentralizedDatasourceSchemaConfig DEFAULT = new CentralizedDatasourceSchemaConfig(null, null, null, null);
    public static final int SCHEMA_VERSION = 1;
    @JsonProperty
    private final boolean enabled;
    @JsonProperty
    private final boolean taskSchemaPublishDisabled;
    @JsonProperty
    private final boolean backFillEnabled;
    @JsonProperty
    private final long backFillPeriod;

    @JsonCreator
    public CentralizedDatasourceSchemaConfig(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="backFillEnabled") @Nullable Boolean backFillEnabled, @JsonProperty(value="backFillPeriod") @Nullable Long backFillPeriod, @JsonProperty(value="taskSchemaPublishDisabled") @Nullable Boolean taskSchemaPublishDisabled) {
        this.enabled = Configs.valueOrDefault((Boolean)enabled, (boolean)false);
        this.backFillEnabled = Configs.valueOrDefault((Boolean)backFillEnabled, (boolean)true);
        this.backFillPeriod = Configs.valueOrDefault((Long)backFillPeriod, (long)60000L);
        this.taskSchemaPublishDisabled = Configs.valueOrDefault((Boolean)taskSchemaPublishDisabled, (boolean)false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isBackFillEnabled() {
        return this.backFillEnabled;
    }

    public long getBackFillPeriodInMillis() {
        return this.backFillPeriod;
    }

    public boolean isTaskSchemaPublishDisabled() {
        return this.taskSchemaPublishDisabled;
    }

    public static CentralizedDatasourceSchemaConfig create() {
        return DEFAULT;
    }

    public static CentralizedDatasourceSchemaConfig enabled(boolean enabled) {
        return new CentralizedDatasourceSchemaConfig(enabled, null, null, null);
    }
}

