/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.joda.time.Period;

public class InlineSchemaDataSourceCompactionConfig
implements DataSourceCompactionConfig {
    private final String dataSource;
    private final int taskPriority;
    private final long inputSegmentSizeBytes;
    @Nullable
    private final Integer maxRowsPerSegment;
    private final Period skipOffsetFromLatest;
    @Nullable
    private final UserCompactionTaskQueryTuningConfig tuningConfig;
    @Nullable
    private final UserCompactionTaskGranularityConfig granularitySpec;
    @Nullable
    private final UserCompactionTaskDimensionsConfig dimensionsSpec;
    @Nullable
    private final AggregatorFactory[] metricsSpec;
    @Nullable
    private final CompactionTransformSpec transformSpec;
    @Nullable
    private final List<AggregateProjectionSpec> projections;
    @Nullable
    private final UserCompactionTaskIOConfig ioConfig;
    @Nullable
    private final Map<String, Object> taskContext;
    @Nullable
    private final CompactionEngine engine;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public InlineSchemaDataSourceCompactionConfig(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="taskPriority") @Nullable Integer taskPriority, @JsonProperty(value="inputSegmentSizeBytes") @Nullable Long inputSegmentSizeBytes, @JsonProperty(value="maxRowsPerSegment") @Deprecated @Nullable Integer maxRowsPerSegment, @JsonProperty(value="skipOffsetFromLatest") @Nullable Period skipOffsetFromLatest, @JsonProperty(value="tuningConfig") @Nullable UserCompactionTaskQueryTuningConfig tuningConfig, @JsonProperty(value="granularitySpec") @Nullable UserCompactionTaskGranularityConfig granularitySpec, @JsonProperty(value="dimensionsSpec") @Nullable UserCompactionTaskDimensionsConfig dimensionsSpec, @JsonProperty(value="metricsSpec") @Nullable AggregatorFactory[] metricsSpec, @JsonProperty(value="transformSpec") @Nullable CompactionTransformSpec transformSpec, @JsonProperty(value="projections") @Nullable List<AggregateProjectionSpec> projections, @JsonProperty(value="ioConfig") @Nullable UserCompactionTaskIOConfig ioConfig, @JsonProperty(value="engine") @Nullable CompactionEngine engine, @JsonProperty(value="taskContext") @Nullable Map<String, Object> taskContext) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.taskPriority = taskPriority == null ? 25 : taskPriority;
        this.inputSegmentSizeBytes = inputSegmentSizeBytes == null ? 100000000000000L : inputSegmentSizeBytes;
        this.maxRowsPerSegment = maxRowsPerSegment;
        this.skipOffsetFromLatest = skipOffsetFromLatest == null ? DEFAULT_SKIP_OFFSET_FROM_LATEST : skipOffsetFromLatest;
        this.tuningConfig = tuningConfig;
        this.ioConfig = ioConfig;
        this.granularitySpec = granularitySpec;
        this.metricsSpec = metricsSpec;
        this.dimensionsSpec = dimensionsSpec;
        this.transformSpec = transformSpec;
        this.projections = projections;
        this.taskContext = taskContext;
        this.engine = engine;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    @JsonProperty
    public int getTaskPriority() {
        return this.taskPriority;
    }

    @Override
    @JsonProperty
    public long getInputSegmentSizeBytes() {
        return this.inputSegmentSizeBytes;
    }

    @Override
    @Deprecated
    @JsonProperty
    @Nullable
    public Integer getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @Override
    @JsonProperty
    public Period getSkipOffsetFromLatest() {
        return this.skipOffsetFromLatest;
    }

    @Override
    @JsonProperty
    @Nullable
    public UserCompactionTaskQueryTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @Override
    @JsonProperty
    @Nullable
    public UserCompactionTaskIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @Override
    @JsonProperty
    @Nullable
    public UserCompactionTaskGranularityConfig getGranularitySpec() {
        return this.granularitySpec;
    }

    @Override
    @JsonProperty
    @Nullable
    public UserCompactionTaskDimensionsConfig getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @Override
    @JsonProperty
    @Nullable
    public CompactionTransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    @Override
    @JsonProperty
    @Nullable
    public AggregatorFactory[] getMetricsSpec() {
        return this.metricsSpec;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<AggregateProjectionSpec> getProjections() {
        return this.projections;
    }

    @Override
    @JsonProperty
    @Nullable
    public Map<String, Object> getTaskContext() {
        return this.taskContext;
    }

    @Override
    @JsonProperty
    @Nullable
    public CompactionEngine getEngine() {
        return this.engine;
    }

    @Override
    @Nullable
    @JsonIgnore
    public Granularity getSegmentGranularity() {
        return this.granularitySpec == null ? null : this.granularitySpec.getSegmentGranularity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineSchemaDataSourceCompactionConfig that = (InlineSchemaDataSourceCompactionConfig)o;
        return this.taskPriority == that.taskPriority && this.inputSegmentSizeBytes == that.inputSegmentSizeBytes && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.maxRowsPerSegment, that.maxRowsPerSegment) && Objects.equals(this.skipOffsetFromLatest, that.skipOffsetFromLatest) && Objects.equals(this.tuningConfig, that.tuningConfig) && Objects.equals(this.granularitySpec, that.granularitySpec) && Objects.equals(this.dimensionsSpec, that.dimensionsSpec) && Arrays.equals(this.metricsSpec, that.metricsSpec) && Objects.equals(this.transformSpec, that.transformSpec) && Objects.equals(this.projections, that.projections) && Objects.equals(this.ioConfig, that.ioConfig) && this.engine == that.engine && Objects.equals(this.taskContext, that.taskContext);
    }

    public int hashCode() {
        int result = Objects.hash(this.dataSource, this.taskPriority, this.inputSegmentSizeBytes, this.maxRowsPerSegment, this.skipOffsetFromLatest, this.tuningConfig, this.granularitySpec, this.dimensionsSpec, this.transformSpec, this.projections, this.ioConfig, this.taskContext, this.engine);
        result = 31 * result + Arrays.hashCode(this.metricsSpec);
        return result;
    }

    public static class Builder {
        private String dataSource;
        private Integer taskPriority;
        private Long inputSegmentSizeBytes;
        private Integer maxRowsPerSegment;
        private Period skipOffsetFromLatest;
        private UserCompactionTaskQueryTuningConfig tuningConfig;
        private UserCompactionTaskGranularityConfig granularitySpec;
        private UserCompactionTaskDimensionsConfig dimensionsSpec;
        private AggregatorFactory[] metricsSpec;
        private CompactionTransformSpec transformSpec;
        private List<AggregateProjectionSpec> projections;
        private UserCompactionTaskIOConfig ioConfig;
        private CompactionEngine engine;
        private Map<String, Object> taskContext;

        public InlineSchemaDataSourceCompactionConfig build() {
            return new InlineSchemaDataSourceCompactionConfig(this.dataSource, this.taskPriority, this.inputSegmentSizeBytes, this.maxRowsPerSegment, this.skipOffsetFromLatest, this.tuningConfig, this.granularitySpec, this.dimensionsSpec, this.metricsSpec, this.transformSpec, this.projections, this.ioConfig, this.engine, this.taskContext);
        }

        public Builder forDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder withTaskPriority(Integer taskPriority) {
            this.taskPriority = taskPriority;
            return this;
        }

        public Builder withInputSegmentSizeBytes(Long inputSegmentSizeBytes) {
            this.inputSegmentSizeBytes = inputSegmentSizeBytes;
            return this;
        }

        @Deprecated
        public Builder withMaxRowsPerSegment(Integer maxRowsPerSegment) {
            this.maxRowsPerSegment = maxRowsPerSegment;
            return this;
        }

        public Builder withSkipOffsetFromLatest(Period skipOffsetFromLatest) {
            this.skipOffsetFromLatest = skipOffsetFromLatest;
            return this;
        }

        public Builder withTuningConfig(UserCompactionTaskQueryTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        public Builder withGranularitySpec(UserCompactionTaskGranularityConfig granularitySpec) {
            this.granularitySpec = granularitySpec;
            return this;
        }

        public Builder withDimensionsSpec(UserCompactionTaskDimensionsConfig dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec;
            return this;
        }

        public Builder withMetricsSpec(AggregatorFactory[] metricsSpec) {
            this.metricsSpec = metricsSpec;
            return this;
        }

        public Builder withTransformSpec(CompactionTransformSpec transformSpec) {
            this.transformSpec = transformSpec;
            return this;
        }

        public Builder withProjections(List<AggregateProjectionSpec> projections) {
            this.projections = projections;
            return this;
        }

        public Builder withIoConfig(UserCompactionTaskIOConfig ioConfig) {
            this.ioConfig = ioConfig;
            return this;
        }

        public Builder withEngine(CompactionEngine engine) {
            this.engine = engine;
            return this;
        }

        public Builder withTaskContext(Map<String, Object> taskContext) {
            this.taskContext = taskContext;
            return this;
        }
    }
}

