/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.server.coordinator.rules.BroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.Rules;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IntervalBroadcastDistributionRule
extends BroadcastDistributionRule {
    static final String TYPE = "broadcastByInterval";
    private final Interval interval;

    @JsonCreator
    public IntervalBroadcastDistributionRule(@JsonProperty(value="interval") Interval interval) {
        this.interval = interval;
    }

    @Override
    @JsonProperty
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        return Rules.eligibleForLoad(this.interval, interval);
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalBroadcastDistributionRule that = (IntervalBroadcastDistributionRule)o;
        return Objects.equals(this.getInterval(), that.getInterval());
    }

    public int hashCode() {
        return Objects.hash(this.getInterval());
    }
}

