/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.http.ServletResourceUtils;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.security.AuthorizationUtils;

@Path(value="/druid/coordinator/v1/config/compaction")
@ResourceFilters(value={ConfigResourceFilter.class})
public class CoordinatorCompactionConfigsResource {
    private final CoordinatorConfigManager configManager;

    @Inject
    public CoordinatorCompactionConfigsResource(CoordinatorConfigManager configManager) {
        this.configManager = configManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCompactionConfig() {
        return ServletResourceUtils.buildReadResponse(this.configManager::getCurrentCompactionConfig);
    }

    @POST
    @Deprecated
    @Path(value="/taskslots")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setCompactionTaskLimit(@QueryParam(value="ratio") Double compactionTaskSlotRatio, @QueryParam(value="max") Integer maxCompactionTaskSlots, @Context HttpServletRequest req) {
        if (compactionTaskSlotRatio == null && maxCompactionTaskSlots == null) {
            return ServletResourceUtils.buildUpdateResponse(() -> true);
        }
        AuditInfo auditInfo = AuthorizationUtils.buildAuditInfo(req);
        return ServletResourceUtils.buildUpdateResponse(() -> this.configManager.updateCompactionTaskSlots(compactionTaskSlotRatio, maxCompactionTaskSlots, auditInfo));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addOrUpdateDatasourceCompactionConfig(DataSourceCompactionConfig newConfig, @Context HttpServletRequest req) {
        AuditInfo auditInfo = AuthorizationUtils.buildAuditInfo(req);
        return ServletResourceUtils.buildUpdateResponse(() -> {
            if (newConfig.getEngine() == CompactionEngine.MSQ) {
                throw InvalidInput.exception((String)"MSQ engine is supported only with supervisor-based compaction on the Overlord.", (Object[])new Object[0]);
            }
            return this.configManager.updateDatasourceCompactionConfig(newConfig, auditInfo);
        });
    }

    @GET
    @Path(value="/{dataSource}")
    @Produces(value={"application/json"})
    public Response getDatasourceCompactionConfig(@PathParam(value="dataSource") String dataSource) {
        return ServletResourceUtils.buildReadResponse(() -> this.configManager.getDatasourceCompactionConfig(dataSource));
    }

    @GET
    @Path(value="/{dataSource}/history")
    @Produces(value={"application/json"})
    public Response getCompactionConfigHistory(@PathParam(value="dataSource") String dataSource, @QueryParam(value="interval") String interval, @QueryParam(value="count") Integer count) {
        return ServletResourceUtils.buildReadResponse(() -> this.configManager.getCompactionConfigHistory(dataSource, interval, count));
    }

    @DELETE
    @Path(value="/{dataSource}")
    @Produces(value={"application/json"})
    public Response deleteCompactionConfig(@PathParam(value="dataSource") String dataSource, @Context HttpServletRequest req) {
        AuditInfo auditInfo = AuthorizationUtils.buildAuditInfo(req);
        return ServletResourceUtils.buildUpdateResponse(() -> this.configManager.deleteDatasourceCompactionConfig(dataSource, auditInfo));
    }
}

