/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.joni.Regex;
import org.joni.ast.EncloseNode;
import org.joni.exception.InternalException;

public final class UnsetAddrList {
    EncloseNode[] targets;
    int[] offsets;
    int num;

    public UnsetAddrList(int size) {
        this.targets = new EncloseNode[size];
        this.offsets = new int[size];
    }

    public void add(int offset, EncloseNode node) {
        if (this.num >= this.offsets.length) {
            EncloseNode[] ttmp = new EncloseNode[this.targets.length << 1];
            System.arraycopy(this.targets, 0, ttmp, 0, this.num);
            this.targets = ttmp;
            int[] otmp = new int[this.offsets.length << 1];
            System.arraycopy(this.offsets, 0, otmp, 0, this.num);
            this.offsets = otmp;
        }
        this.targets[this.num] = node;
        this.offsets[this.num] = offset;
        ++this.num;
    }

    public void fix(Regex regex) {
        for (int i = 0; i < this.num; ++i) {
            EncloseNode en = this.targets[i];
            if (!en.isAddrFixed()) {
                new InternalException("internal parser error (bug)");
            }
            regex.code[this.offsets[i]] = en.callAddr;
        }
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        if (this.num > 0) {
            for (int i = 0; i < this.num; ++i) {
                value.append("offset + " + this.offsets[i] + " target: " + this.targets[i].getAddressName());
            }
        }
        return value.toString();
    }
}

