/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import java.util.Objects;
import java.util.Optional;

public class ClientSideConfig {
    private static ClientSideConfig defaultConfig = new ClientSideConfig(Versions.getLatest(), Optional.empty());
    private final Version backwardCompatibilityVersion;
    private final Optional<TimeMeter> clientSideClock;

    protected ClientSideConfig(Version backwardCompatibilityVersion, Optional<TimeMeter> clientSideClock) {
        this.backwardCompatibilityVersion = Objects.requireNonNull(backwardCompatibilityVersion);
        this.clientSideClock = Objects.requireNonNull(clientSideClock);
    }

    public static ClientSideConfig getDefault() {
        return defaultConfig;
    }

    public ClientSideConfig backwardCompatibleWith(Version backwardCompatibilityVersion) {
        return new ClientSideConfig(backwardCompatibilityVersion, this.clientSideClock);
    }

    public ClientSideConfig withClientClock(TimeMeter clientClock) {
        return new ClientSideConfig(this.backwardCompatibilityVersion, Optional.of(clientClock));
    }

    public Optional<TimeMeter> getClientSideClock() {
        return this.clientSideClock;
    }

    public Version getBackwardCompatibilityVersion() {
        return this.backwardCompatibilityVersion;
    }
}

