/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramFoldingBufferAggregatorHelper;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class ApproximateHistogramFoldingVectorAggregator
implements VectorAggregator {
    private final ApproximateHistogramFoldingBufferAggregatorHelper innerAggregator;
    private final VectorObjectSelector selector;

    public ApproximateHistogramFoldingVectorAggregator(VectorObjectSelector selector, int resolution, float lowerLimit, float upperLimit) {
        this.selector = selector;
        this.innerAggregator = new ApproximateHistogramFoldingBufferAggregatorHelper(resolution, lowerLimit, upperLimit);
    }

    public void init(ByteBuffer buf, int position) {
        this.innerAggregator.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        Object[] vector = this.selector.getObjectVector();
        ApproximateHistogram histogram = this.innerAggregator.get(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            ApproximateHistogram other = (ApproximateHistogram)vector[i];
            if (null == other) continue;
            this.innerAggregator.foldFast(histogram, other);
        }
        this.innerAggregator.put(buf, position, histogram);
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.selector.getObjectVector();
        for (int i = 0; i < numRows; ++i) {
            ApproximateHistogram other = (ApproximateHistogram)vector[null != rows ? rows[i] : i];
            if (null == other) continue;
            int position = positions[i] + positionOffset;
            this.innerAggregator.aggregate(buf, position, other);
        }
    }

    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return this.innerAggregator.get(buf, position);
    }

    public void close() {
    }
}

